<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Usuario extends MX_Controller {

    function index($pagina_id) {

        $this->load->model('usuariomodel', 'modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['lista'] = $this->modelo->lista();
        $data['perfilcombo'] = $this->modelo->perfilcombo();
        $data['usuarioPermissaoPerfil'] = $this->modelo->usuarioPermissaoPerfil($this->session->userdata('id'));
        $data['view'] = 'usuarioview';
        
        $this->my_template->show($data);
    }

    function filiacao($filiado) {

        $this->load->model('usuariomodel', 'modelo');
        $data['afiliado'] = $this->modelo->buscaRegistro('adminacesso', $filiado);
        $data['lista'] = $this->modelo->listafiliacao($filiado);
        $data['view'] = 'usuariofiliacaoview';
        
        $this->my_template->show($data);
    }

    function form($pagina_id, $id=''){

        ini_set('error_reporting', E_STRICT);
        $this->load->model('usuariomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['s'] = $this->modelo->buscaRegistro($pagina[0]->tabela, $id);
        $data['usuarioPermissaoPerfil'] = $this->modelo->usuarioPermissaoPerfil($this->session->userdata('id'));
        $data['lista'] = $this->modelo->lista();
        $data['view'] = 'usuarioformview';
        
        $this->my_template->show($data);
    }    

    function formatabela($pagina_id){

        $this->load->model('usuariomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $lista = $this->modelo->lista();
        $resultado = ' { "data": [ ';
        
        foreach($lista as $key => $row){
	        	if($key != '0'){
	        		$resultado .=  ',';
	        	}
	        	if ($row->status == 1){$statusnome = "Ativo";}else{$statusnome = "Inativo";}
	        	if ($row->descricao){$perfilnome = $row->descricao;}else{$perfilnome = "Externo";}
	        	$acao = "<a href='".base_url().$pagina[0]->pagina."/form/".$pagina[0]->id."/".$row->id."' class='btn btn-primary btn-circle btn-xl'><i class='fa fa-list'></i>&nbsp;&nbsp;Editar</a>";
	        	if($row->imagem) {
	        		$acao .= " <a href='#' class='btn orange btn-xl' data-toggle='modal' data-target='#myModal-orange".$row->id."'>Imagem</a>";
	         }
		      $acao .= " <a href='#' class='btn red btn-xl' data-toggle='modal' data-target='#myModal-azul".$row->id."'>Visualizar</a>";
		      $resultado .=  ' [ ';
				$resultado .=  '
					      "'.$row->nome.'",
					      "'.$row->email.'",
					      "'.$perfilnome.'",
					      "'.$statusnome.'",
					      "'.$acao.'"
					    ]';
        }
        $resultado .= ' ] } ';
        echo $resultado;
    }

    function permissao($usuario=''){

        ini_set('error_reporting', E_STRICT);
        $p['tabela'] = 'adminacessopermissao';
        $this->load->model('usuariomodel','modelo');
        $data['usuario'] = $this->modelo->buscaRegistro("adminacesso",$usuario);
        $data['perfilPermissao'] = $this->modelo->perfilPermissao($usuario);
        $data['p'] = $p;
        $data['view'] = 'usuariopermissaoview';
        
        $this->my_template->show($data);
    }    
    
    
    function salvar(){

        $this->my_acesso->token();
        $this->load->model('usuariomodel','modelo');
        $email = $this->input->post('email');
        if($email){
            $usuarioexiste = $this->modelo->usuarioexiste();
            if(!$usuarioexiste){
                $imagemNome = $this->modelo->inserearquivo("imagem");
                $retorno['id'] = $this->modelo->salva($imagemNome);
                if($retorno['id']){
                    $retorno['mensagem'] = "Dados foram salvos com sucesso. ";
                    if(!$this->input->post('id')){
                        if (!$this->input->post('senha')){
                            $retorno['geratoken'] = $this->modelo->geratoken();
                            if($retorno['geratoken']){
                                $retorno['mensagem'] .= "Foi enviado um email para a geração de uma nova senha.";
                            }else{
                                $retorno['mensagem'] .= "Houve erro ao tentar gerar a senha. Contate o administrador do sistema.";
                            }
                        }
                    }
                }else{
                    $retorno['mensagem'] = "Houve erro ao tentar salvar.";
                }
            }else{
                    $retorno['mensagem'] = "Este e-mail já pertence a outro usuário.";
            }
        }
        echo json_encode($retorno);        
    }    
    
    function gerasenha() {

        $retorno['mensagem'] = "";
        $email = $this->input->post('email');
        if($email){
            $this->load->model('usuariomodel', 'modelo');
            $emailexiste = $this->modelo->emailexiste();
            
            if($emailexiste){
                $retorno['id'] = $this->modelo->geratoken();
                if($retorno['id']){
                    $retorno['mensagem'] .= "Foi enviado um email para a geração de uma nova senha.";
                }else{
                    $retorno['mensagem'] .= "Houve erro ao tentar gerar a senha. Contate o administrador do sistema.";
                }
            }else{
                $retorno['id'] = false;
                $retorno['mensagem'] .= "Usário não cadastrado o inativo.";
            }
        }
        echo json_encode($retorno); 
    }
    
    function salvarPermissao(){
        $this->my_acesso->token();
        $this->load->model('usuariomodel','modelo');
        $retorno['id'] = $this->modelo->salvaPermissao();
        //echo $retorno;
        if($retorno['id']){
            $retorno['mensagem'] = 'Dados foram salvos com sucesso.';
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar salvar.';
        }
        echo json_encode($retorno);
    }     
}

