<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Imagem extends MX_Controller {

    function index($pagina_id) {
        
        $this->load->model('imagemmodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['lista'] = $this->modelo->lista($pagina[0]->tabela);
        $data['view'] = 'imagemview';
        
        $this->my_template->show($data);
    }
    
    function form($pagina_id, $id=''){

        ini_set('error_reporting', E_STRICT);
        $this->load->model('imagemmodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['s'] = $this->modelo->buscaRegistro($pagina[0]->tabela, $id);
        $data['lista'] = $this->modelo->lista($pagina[0]->tabela);
        $data['view'] = 'imagemformview';
        
        $this->my_template->show($data);
    }    
    
    function salvar(){
        $this->my_acesso->token();
        $this->load->model('imagemmodel','modelo');
		$imagemNome = $this->inserearquivo("imagem");
        $retorno['id'] = $this->modelo->salva($imagemNome);
        //echo $retorno;
        if($retorno['id']){
            $retorno['mensagem'] = 'Dados foram salvos com sucesso.';
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar salvar.';
        }
        echo json_encode($retorno);
    }        

    function inserearquivo($arquivo){
        
        $config['upload_path'] = './public/biblioteca-de-arquivos/'.$this->input->post('tabela').'/';
        $config['allowed_types'] = 'jpg|jpeg|png|bmp|gif';
        $config['encrypt_name'] = TRUE;
        //$config['max_width']  = '1024';
        //$config['max_height']  = '768';

        $this->load->library('upload', $config);
        if ($this->upload->do_upload($arquivo))
        {
            $upload_data = $this->upload->data();
            if($upload_data['is_image']){
                $nome_do_arquivo_gravado = $upload_data['file_name'];
            } else {
                $nome_do_arquivo_gravado = "";
            }
            return $nome_do_arquivo_gravado;
        }
    }    
}

