<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Cursomodulo extends MX_Controller {

    function index($pagina_id, $curso) {
        
        $this->load->model('cursomodulomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['lista'] = $this->modelo->lista($pagina[0]->tabela, $curso);
        $data['curso'] = $this->modelo->curso($curso);
        $data['view'] = 'cursomoduloview';
        
        $this->my_template->show($data);
    }
    
    function form($pagina_id, $curso, $id=''){

        ini_set('error_reporting', E_STRICT);
        $this->load->model('cursomodulomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['s'] = $this->modelo->buscaRegistro($pagina[0]->tabela, $id);
        $data['cursomoduloitem'] = $this->modelo->cursomoduloitem($id);
        $data['curso'] = $this->modelo->curso($curso);
        $data['listaprofissionais'] = $this->modelo->listaprofissionais($curso);
        $data['view'] = 'cursomoduloformview';
        
        $this->my_template->show($data);
    }    

    function formvideoaula($pagina_id, $modulo, $curso){

        ini_set('error_reporting', E_STRICT);
        $this->load->model('cursomodulomodel','modelo');
        $data['videoaula'] = $this->modelo->cursoVideoaula($modulo);
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['s'] = $this->modelo->buscaRegistro($pagina[0]->tabela, $modulo);
        $data['p'] = $pagina;		
        $data['modulo'] = $modulo;
        $data['curso'] = $curso;
        $data['view'] = 'cursovideoaulaview';
        
        $this->my_template->show($data);
    }

    function salvar(){
        $this->my_acesso->token();
        $this->load->model('cursomodulomodel','modelo');
        $retorno['id'] = $this->modelo->salva();
        //echo $retorno;
        if($retorno['id']){
            $retorno['mensagem'] = 'Dados foram salvos com sucesso.';
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar salvar.';
        }
        echo json_encode($retorno);
    }

    function salvarvideoaula(){
        $this->my_acesso->token();
        $this->load->model('cursomodulomodel','modelo');
        $retorno['id'] = $this->modelo->salvaVideoaula();
        //echo $retorno;
        if($retorno['id']){
            $retorno['mensagem'] = 'Dados foram salvos com sucesso.';
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar salvar.';
        }
        echo json_encode($retorno);
    }
	
    function alterarOrdem(){
		$retorno = "";
        $this->load->model('cursomodulomodel','modelo');
        if($this->modelo->alterarOrdem()){
            $retorno = $this->input->post('ordem');
        }
        echo $retorno;
    }
}

