<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Curso extends MX_Controller {

    function index($pagina_id) {
        
        $this->load->model('cursomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['lista'] = $this->modelo->lista($pagina[0]->tabela);
        $data['view'] = 'cursoview';
        
        $this->my_template->show($data);
    }
    
    function form($pagina_id, $id=''){

        ini_set('error_reporting', E_STRICT);
        $this->load->model('cursomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['s'] = $this->modelo->buscaRegistro($pagina[0]->tabela, $id);
		$data['uf'] = $this->modelo->uf();
        $data['categoria'] = $this->modelo->categoria($id);
		$data['curso_organizador'] = $this->modelo->curso_organizador($id);
		$data['profissional'] = $this->modelo->profissional();
		$data['profissional_curso'] = $this->modelo->profissional_curso($id);
		$data['curso_lote'] = $this->modelo->curso_lote($id);
        $data['view'] = 'cursoformview';
        
        $this->my_template->show($data);
    }
    
    function salvar(){
        $this->my_acesso->token();
        $this->load->model('cursomodel','modelo');
        $retorno['id'] = $this->modelo->salva();
        //echo $retorno;
        if($retorno['id']){
            $retorno['mensagem'] = 'Dados foram salvos com sucesso.';
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar salvar.';
        }
        echo json_encode($retorno);
    }        
    
    function salvarvideoaula(){
        $this->my_acesso->token();
        $this->load->model('cursomodel','modelo');
        $retorno['id'] = $this->modelo->salvaVideoaula();
        //echo $retorno;
        if($retorno['id']){
            $retorno['mensagem'] = 'Dados foram salvos com sucesso.';
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar salvar.';
        }
        echo json_encode($retorno);
    }        

    function participante($pagina_id, $id) {
        
        $this->load->model('cursomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['participante'] = $this->modelo->listaparticipante($id);
        $data['presenca'] = $this->modelo->presenca($id);
        $data['certificado_enviado'] = $this->modelo->certificado_enviado($id);
        $data['relatorioenvio'] = $this->modelo->relatorioenvio($id);
        $data['view'] = 'cursoparticipanteview';
        
        $this->my_template->show($data);
    }

    function enviarcertificado($pagina_id, $id) {
        
        $this->load->model('cursomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['participante'] = $this->modelo->listaparticipante($id);
        $data['view'] = 'cursoparticipanteview';
        
        $this->my_template->show($data);
    }

    function baixarcertificado($pagina_id, $id) {
        
        $this->load->model('cursomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['participante'] = $this->modelo->listaparticipante($id);
        $data['view'] = 'cursoparticipanteview';
        
        $this->my_template->show($data);
    }

    function exportar_excel($pagina_id, $id) {
        
		$this->load->library('export');
        $this->load->model('cursomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $curso = $this->modelo->buscaRegistro($pagina[0]->tabela, $id);
        $lista_excel = $this->modelo->lista_excel($pagina[0]->tabela, $id);

		$this->export->to_excel($lista_excel, 'participantes do curso '.$curso[0]->titulo);
	}

    function marcarparticipantetodos() {
        
        $this->load->model('cursomodel','modelo');
        $retorno = true;
        $lista = $this->modelo->listaparticipante($this->input->post('curso'));

        if($this->input->post('acao')){
            foreach($lista as $s){
                if(!$this->modelo->marcarparticipante($s->id)){
                    $retorno = false;
                }
            }
        } else {
            foreach($lista as $s){
                if(!$this->modelo->desmarcarparticipante($s->id)){
                    $retorno = false;
                }
            }
        }
        echo $this->input->post('acao');
	}

    function marcarparticipante() {
        
        $this->load->model('cursomodel','modelo');
        if($this->input->post('acao')){
            $this->modelo->marcarparticipante($this->input->post('participante'));
        } else {
            $this->modelo->desmarcarparticipante($this->input->post('participante'));
        }
        //echo $this->input->post('curso'). " - ".$this->input->post('participante');
	}
	
    function cancelarinscricao() {
        $this->load->model('cursomodel','modelo');
        $this->modelo->cancelamentoinscricao();
        //$this->autualizarvendas($this->input->post('produto'));
        //echo "teste";
    }
    
    function autualizarvendas($id) {
        $this->load->model('produto/produtomodel', 'modelo');
        $this->modelo->autualizaVendas($id);
    }
}

