<!DOCTYPE html>
<html lang="pt-br" dir="ltr">

<?php $this->load->view('painel/incPainelHead'); ?>

<style>
    .chamado_selecao:hover{
        background-color: #E8E8E8;
        cursor: pointer;
    }
</style>

<body class="layout-sticky-subnav layout-default ">

    <div class="preloader">
        <div class="sk-double-bounce">
            <div class="sk-child sk-double-bounce1"></div>
            <div class="sk-child sk-double-bounce2"></div>
        </div>
    </div>

    <!-- Header Layout -->
    <div class="mdk-header-layout js-mdk-header-layout">

<?php $this->load->view('painel/incPainelHeader'); ?>

        <!-- Header Layout Content -->
        <div class="mdk-header-layout__content page-content ">



            <div class="pt-32pt">
                <div class="container page__container d-flex flex-column flex-md-row align-items-center text-center text-sm-left">
                    <div class="flex d-flex flex-column flex-sm-row align-items-center mb-24pt mb-md-0">
                        <div class="mb-24pt mb-sm-0 mr-sm-24pt">
                            <h2 class="mb-0">
            					<?php if(empty($usuario)){ ?>
            						Cadastro
            					<?php }else{ ?>
            						<span class="material-icons sidebar-menu-icon sidebar-menu-icon--left" style="font-size: 33px !important; padding-bottom: 8px;">account_box</span>Perfil
            					<?php } ?>
                            </h2><br />
                        </div>
                    </div>
                </div>
            </div>



            <div class="container page__container">

            		<div class="grid_12 login_text">
            			<?php if($this->session->userdata('pre_email') && empty($usuario)){ ?>
            				Olá 
            				<?php 
            				$usunome = explode(" ", $this->session->userdata('pre_nome'));
            				echo $usunome[0]; ?>, por favor complete o seu cadastro.
            			<?php }elseif(empty($usuario)){ ?>
            					Cadastre-se para efetuar compras e para receber conteúdo exclusivo gratuito.
            			<?php } ?>
            		</div>
                    <form id="form-usuario" method="POST" action="<?php echo base_url();?>usuario/salvar" enctype="multipart/form-data">

                        <div class="flex" style="max-width: 100%">
                            <div class="was-validated">

                        <div class="form-group">
                            <div class="media align-items-center">
                            	<?php if($usuario[0]->imagem){ ?>
                            		<a href="" class="media-left mr-16pt">
                                    <img src="<?php echo base_url();?>iportal/public/biblioteca-de-arquivos/adminacesso/<?php echo $usuario[0]->imagem; ?>" alt="people" width="56" class="rounded-circle" />
                                    </a>
                                <?php } ?>
    
                                <div class="media-body">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="imagem" name="imagem" accept="image/*">
                                        <label class="custom-file-label" for="inputGroupFile01">Selecionar imagem</label>
                                    </div>
                                </div>
                              </div>
                          </div>

                     

                            <div class="form-group">
                                        <input type="text" class="form-control" id="email" name="email" onBlur="checaEmail();" value="<?php echo $usuario[0]->email; ?><?php if(empty($usuario)){echo $this->session->userdata('pre_email');} ?>" placeholder="E-mail (login)" required="">
                                        <div class="invalid-feedback">E-mail é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>
                            
                            <?php if(empty($usuario)){ ?>
                            <div class="form-group">
                                        <input type="text" class="form-control" id="emailconfirma" name="emailconfirma" onBlur="checaEmailConfirma();" value="<?php echo $usuario[0]->email; ?><?php if(empty($usuario)){echo $this->session->userdata('pre_email');} ?>" placeholder="Confirmação de e-mail" required="">
                                        <div class="invalid-feedback">Confirmação de e-mail é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>
                            <?php } ?>
                            
                            <div class="form-group">
                                        <input type="text" class="form-control" id="nome" name="nome" placeholder="Nome" value="<?php echo $usuario[0]->nome; ?><?php if(empty($usuario)){echo $this->session->userdata('pre_nome');} ?>" required="">
                                        <div class="invalid-feedback">Nome é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>

                            <div class="form-group">
                                <select name="pessoa" id="pessoa" class="form-control custom-select" required="">
                                    <option value="">Escolha o tipo de pessoa: física ou jurídica *</option>
                                    <option value="F" <?php if($usuario[0]->pessoa === "F"){echo "selected";} ?>>Física</option>
                                    <option value="J" <?php if($usuario[0]->pessoa === "J"){echo "selected";} ?>>Jurídica</option>
                                </select>
                                        <div class="invalid-feedback">Pessoa é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>
                            
                            <div id="div-pessoa">
                            </div>
                            
                            <div class="form-group">
                                <select name="sexo" id="sexo" class="form-control custom-select" required="">
                                    <option value="">Selecione o sexo</option>
                                    <option value="M" <?php if($usuario[0]->sexo === "M"){echo "selected";} ?>>Masculino</option>
                                    <option value="F" <?php if($usuario[0]->sexo === "F"){echo "selected";} ?>>Feminino</option>
                                </select>
                                        <div class="invalid-feedback">Sexo é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>
                            
                            <div class="form-group">
                                        <input type="text" class="form-control" id="nascimento" name="nascimento" data-mask="00/00/0000" placeholder="Data de nascimento" value="<?php if($usuario[0]->nascimento){ echo date("d/m/Y", strtotime($usuario[0]->nascimento)); } ?>" required="">
                                        <div class="invalid-feedback">Data de nascimento é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>
                            
                            <div class="form-group">
                                        <input type="text" class="form-control" id="endereco" name="endereco" placeholder="Endereço completo" value="<?php echo $usuario[0]->endereco; ?>" required="">
                                        <div class="invalid-feedback">Endereço completo é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>
                            
                            <div class="form-group">
                                        <input type="text" class="form-control" id="bairro" name="bairro" placeholder="Bairro" value="<?php echo $usuario[0]->bairro; ?>" required="">
                                        <div class="invalid-feedback">Bairro é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>

                            <div class="form-group">
                                        <input type="text" class="form-control" id="cidade" name="cidade" placeholder="Cidade" value="<?php echo $usuario[0]->cidade; ?>" required="">
                                        <div class="invalid-feedback">Cidade é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>

                            <div class="form-group">
                                        <input type="text" class="form-control" data-mask="99.999-999" id="cep" name="cep" placeholder="CEP" value="<?php echo $usuario[0]->cep; ?>" required="">
                                        <div class="invalid-feedback">CEP é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>
                            
                            <div class="form-group">
                                <select name="uf" id="uf" class="form-control custom-select" required="">
                                    <option value="">Selecione o estado</option>
                                    <?php foreach ($uf as $row) { ?>
                                    	<option value="<?php echo $row->uf; ?>" <?php if($usuario[0]->uf === $row->uf){echo "selected";} ?>><?php echo $row->descricao; ?></option>
                                    <?php } ?>
                                </select>
                                        <div class="invalid-feedback">Estado é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>                            
                            
                             <div class="form-group">
                                        <input type="text" class="form-control telefone" id="telcom" name="telcom" placeholder="Telefone comercial" value="<?php echo $usuario[0]->telcom; ?>">
                            </div>                           
                            
                             <div class="form-group">
                                        <input type="text" class="form-control telefone" id="telcel" name="telcel" placeholder="Telefone celular" value="<?php echo $usuario[0]->telcel; ?>">
                            </div> 

                            <div class="form-group">
                                <select name="sabendo" id="sabendo" class="form-control custom-select">
									<option value="">Como soube do site <?php echo $this->session->userdata('nome_projeto'); ?>?</option>
		                            <option value="Internet" <?php if($usuario[0]->sabendo === "Internet"){echo "selected";} ?>>Internet</option>
		                            <option value="E-mail marketing" <?php if($usuario[0]->sabendo === "E-mail marketing"){echo "selected";} ?>>E-mail marketing</option>
		                            <option value="Facebook" <?php if($usuario[0]->sabendo === "Facebook"){echo "selected";} ?>>Facebook</option>
		                            <option value="Instagram" <?php if($usuario[0]->sabendo === "Instagram"){echo "selected";} ?>>Instagram</option>
		                            <option value="Whatsapp" <?php if($usuario[0]->sabendo === "Whatsapp"){echo "selected";} ?>>Whatsapp</option>
		                            <option value="Indicação de amigos" <?php if($usuario[0]->sabendo === "Indicação de amigos"){echo "selected";} ?>>Indicação de amigos</option>
		                            <option value="Eventos" <?php if($usuario[0]->sabendo === "Eventos"){echo "selected";} ?>>Eventos</option>
		                            <option value="Outros" <?php if($usuario[0]->sabendo === "Outros"){echo "selected";} ?>>Outros</option>
                                </select>
                            </div>

                            <div class="form-group">
                                        <input type="password" class="form-control" id="senha" name="senha" placeholder="Bairro" value="">
                            </div>

                            <div class="form-group">
                                        <input type="password" class="form-control" id="senhaconfirma" name="senhaconfirma" placeholder="Bairro" value="">
                            </div>

                            <input type="button" onclick="submitForm();" id="submit-usuario" style="width: 100%; text-align: center;" class="btn btn-primary" value="Salvar" />
                            <!--input type="submit"  id="submit-usuario" style="width: 96%;text-align: center;" value="Salvar" /-->
					
					</div>
					</div>
				</form>    
				<br/><br/>
				<!--/ .contact-form--> 
                <div id="messageStatus"></div>
                <div id="timerstart"></div>
  
            </div>

        </div>
        <!-- // END Header Layout Content -->

<div id="div-pessoa1" style="display: none;">
    <div class="form-group">
                <input type="text" class="form-control" id="cpf" name="cpf" data-mask="000.000.000-00" placeholder="CPF" value="<?php echo $usuario[0]->cpf; ?>" required="">
                <div class="invalid-feedback">CPF é um campo obrigatório.</div>
                <div class="valid-feedback"></div>
    </div>
</div>

<div id="div-pessoa2" style="display: none;">
    <div class="form-group">
                <input type="text" class="form-control" id="cpf" name="cpf" data-mask="00.000.000/0000-00" placeholder="CNPJ" value="<?php echo $usuario[0]->cpf; ?>" required="">
                <div class="invalid-feedback">CNPJ é um campo obrigatório.</div>
                <div class="valid-feedback"></div>
    </div>
</div>

<?php $this->load->view('painel/incPainelFooter'); ?>


    </div>
    <!-- // END Header Layout -->




<?php $this->load->view('painel/incPainelMenu'); ?>



<?php $this->load->view('painel/incPainelScripts'); ?>

</body>
</html>

<script>

var hexcase = 0;  /* hex output format. 0 - lowercase; 1 - uppercase        */
var b64pad  = ""; /* base-64 pad character. "=" for strict RFC compliance   */
var chrsz   = 8;  /* bits per input character. 8 - ASCII; 16 - Unicode      */

/*
* These are the functions you'll usually want to call
* They take string arguments and return either hex or base-64 encoded strings
*/
function hex_md5(s){ return binl2hex(core_md5(str2binl(s), s.length * chrsz));}
function b64_md5(s){ return binl2b64(core_md5(str2binl(s), s.length * chrsz));}
function str_md5(s){ return binl2str(core_md5(str2binl(s), s.length * chrsz));}
function hex_hmac_md5(key, data) { return binl2hex(core_hmac_md5(key, data)); }
function b64_hmac_md5(key, data) { return binl2b64(core_hmac_md5(key, data)); }
function str_hmac_md5(key, data) { return binl2str(core_hmac_md5(key, data)); }

/*
* Perform a simple self-test to see if the VM is working
*/
function md5_vm_test()
{
  return hex_md5("abc") == "900150983cd24fb0d6963f7d28e17f72";
}

/*
* Calculate the MD5 of an array of little-endian words, and a bit length
*/
function core_md5(x, len)
{
  /* append padding */
  x[len >> 5] |= 0x80 << ((len) % 32);
  x[(((len + 64) >>> 9) << 4) + 14] = len;

  var a =  1732584193;
  var b = -271733879;
  var c = -1732584194;
  var d =  271733878;

  for(var i = 0; i < x.length; i += 16)
  {
    var olda = a;
    var oldb = b;
    var oldc = c;
    var oldd = d;

    a = md5_ff(a, b, c, d, x[i+ 0], 7 , -680876936);
    d = md5_ff(d, a, b, c, x[i+ 1], 12, -389564586);
    c = md5_ff(c, d, a, b, x[i+ 2], 17,  606105819);
    b = md5_ff(b, c, d, a, x[i+ 3], 22, -1044525330);
    a = md5_ff(a, b, c, d, x[i+ 4], 7 , -176418897);
    d = md5_ff(d, a, b, c, x[i+ 5], 12,  1200080426);
    c = md5_ff(c, d, a, b, x[i+ 6], 17, -1473231341);
    b = md5_ff(b, c, d, a, x[i+ 7], 22, -45705983);
    a = md5_ff(a, b, c, d, x[i+ 8], 7 ,  1770035416);
    d = md5_ff(d, a, b, c, x[i+ 9], 12, -1958414417);
    c = md5_ff(c, d, a, b, x[i+10], 17, -42063);
    b = md5_ff(b, c, d, a, x[i+11], 22, -1990404162);
    a = md5_ff(a, b, c, d, x[i+12], 7 ,  1804603682);
    d = md5_ff(d, a, b, c, x[i+13], 12, -40341101);
    c = md5_ff(c, d, a, b, x[i+14], 17, -1502002290);
    b = md5_ff(b, c, d, a, x[i+15], 22,  1236535329);

    a = md5_gg(a, b, c, d, x[i+ 1], 5 , -165796510);
    d = md5_gg(d, a, b, c, x[i+ 6], 9 , -1069501632);
    c = md5_gg(c, d, a, b, x[i+11], 14,  643717713);
    b = md5_gg(b, c, d, a, x[i+ 0], 20, -373897302);
    a = md5_gg(a, b, c, d, x[i+ 5], 5 , -701558691);
    d = md5_gg(d, a, b, c, x[i+10], 9 ,  38016083);
    c = md5_gg(c, d, a, b, x[i+15], 14, -660478335);
    b = md5_gg(b, c, d, a, x[i+ 4], 20, -405537848);
    a = md5_gg(a, b, c, d, x[i+ 9], 5 ,  568446438);
    d = md5_gg(d, a, b, c, x[i+14], 9 , -1019803690);
    c = md5_gg(c, d, a, b, x[i+ 3], 14, -187363961);
    b = md5_gg(b, c, d, a, x[i+ 8], 20,  1163531501);
    a = md5_gg(a, b, c, d, x[i+13], 5 , -1444681467);
    d = md5_gg(d, a, b, c, x[i+ 2], 9 , -51403784);
    c = md5_gg(c, d, a, b, x[i+ 7], 14,  1735328473);
    b = md5_gg(b, c, d, a, x[i+12], 20, -1926607734);

    a = md5_hh(a, b, c, d, x[i+ 5], 4 , -378558);
    d = md5_hh(d, a, b, c, x[i+ 8], 11, -2022574463);
    c = md5_hh(c, d, a, b, x[i+11], 16,  1839030562);
    b = md5_hh(b, c, d, a, x[i+14], 23, -35309556);
    a = md5_hh(a, b, c, d, x[i+ 1], 4 , -1530992060);
    d = md5_hh(d, a, b, c, x[i+ 4], 11,  1272893353);
    c = md5_hh(c, d, a, b, x[i+ 7], 16, -155497632);
    b = md5_hh(b, c, d, a, x[i+10], 23, -1094730640);
    a = md5_hh(a, b, c, d, x[i+13], 4 ,  681279174);
    d = md5_hh(d, a, b, c, x[i+ 0], 11, -358537222);
    c = md5_hh(c, d, a, b, x[i+ 3], 16, -722521979);
    b = md5_hh(b, c, d, a, x[i+ 6], 23,  76029189);
    a = md5_hh(a, b, c, d, x[i+ 9], 4 , -640364487);
    d = md5_hh(d, a, b, c, x[i+12], 11, -421815835);
    c = md5_hh(c, d, a, b, x[i+15], 16,  530742520);
    b = md5_hh(b, c, d, a, x[i+ 2], 23, -995338651);

    a = md5_ii(a, b, c, d, x[i+ 0], 6 , -198630844);
    d = md5_ii(d, a, b, c, x[i+ 7], 10,  1126891415);
    c = md5_ii(c, d, a, b, x[i+14], 15, -1416354905);
    b = md5_ii(b, c, d, a, x[i+ 5], 21, -57434055);
    a = md5_ii(a, b, c, d, x[i+12], 6 ,  1700485571);
    d = md5_ii(d, a, b, c, x[i+ 3], 10, -1894986606);
    c = md5_ii(c, d, a, b, x[i+10], 15, -1051523);
    b = md5_ii(b, c, d, a, x[i+ 1], 21, -2054922799);
    a = md5_ii(a, b, c, d, x[i+ 8], 6 ,  1873313359);
    d = md5_ii(d, a, b, c, x[i+15], 10, -30611744);
    c = md5_ii(c, d, a, b, x[i+ 6], 15, -1560198380);
    b = md5_ii(b, c, d, a, x[i+13], 21,  1309151649);
    a = md5_ii(a, b, c, d, x[i+ 4], 6 , -145523070);
    d = md5_ii(d, a, b, c, x[i+11], 10, -1120210379);
    c = md5_ii(c, d, a, b, x[i+ 2], 15,  718787259);
    b = md5_ii(b, c, d, a, x[i+ 9], 21, -343485551);

    a = safe_add(a, olda);
    b = safe_add(b, oldb);
    c = safe_add(c, oldc);
    d = safe_add(d, oldd);
  }
  return Array(a, b, c, d);

}

/*
* These functions implement the four basic operations the algorithm uses.
*/
function md5_cmn(q, a, b, x, s, t)
{
  return safe_add(bit_rol(safe_add(safe_add(a, q), safe_add(x, t)), s),b);
}
function md5_ff(a, b, c, d, x, s, t)
{
  return md5_cmn((b & c) | ((~b) & d), a, b, x, s, t);
}
function md5_gg(a, b, c, d, x, s, t)
{
  return md5_cmn((b & d) | (c & (~d)), a, b, x, s, t);
}
function md5_hh(a, b, c, d, x, s, t)
{
  return md5_cmn(b ^ c ^ d, a, b, x, s, t);
}
function md5_ii(a, b, c, d, x, s, t)
{
  return md5_cmn(c ^ (b | (~d)), a, b, x, s, t);
}

/*
* Calculate the HMAC-MD5, of a key and some data
*/
function core_hmac_md5(key, data)
{
  var bkey = str2binl(key);
  if(bkey.length > 16) bkey = core_md5(bkey, key.length * chrsz);

  var ipad = Array(16), opad = Array(16);
  for(var i = 0; i < 16; i++)
  {
    ipad[i] = bkey[i] ^ 0x36363636;
    opad[i] = bkey[i] ^ 0x5C5C5C5C;
  }

  var hash = core_md5(ipad.concat(str2binl(data)), 512 + data.length * chrsz);
  return core_md5(opad.concat(hash), 512 + 128);
}

/*
* Add integers, wrapping at 2^32. This uses 16-bit operations internally
* to work around bugs in some JS interpreters.
*/
function safe_add(x, y)
{
  var lsw = (x & 0xFFFF) + (y & 0xFFFF);
  var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return (msw << 16) | (lsw & 0xFFFF);
}

/*
* Bitwise rotate a 32-bit number to the left.
*/
function bit_rol(num, cnt)
{
  return (num << cnt) | (num >>> (32 - cnt));
}

/*
* Convert a string to an array of little-endian words
* If chrsz is ASCII, characters >255 have their hi-byte silently ignored.
*/
function str2binl(str)
{
  var bin = Array();
  var mask = (1 << chrsz) - 1;
  for(var i = 0; i < str.length * chrsz; i += chrsz)
    bin[i>>5] |= (str.charCodeAt(i / chrsz) & mask) << (i%32);
  return bin;
}

/*
* Convert an array of little-endian words to a string
*/
function binl2str(bin)
{
  var str = "";
  var mask = (1 << chrsz) - 1;
  for(var i = 0; i < bin.length * 32; i += chrsz)
    str += String.fromCharCode((bin[i>>5] >>> (i % 32)) & mask);
  return str;
}

/*
* Convert an array of little-endian words to a hex string.
*/
function binl2hex(binarray)
{
  var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
  var str = "";
  for(var i = 0; i < binarray.length * 4; i++)
  {
    str += hex_tab.charAt((binarray[i>>2] >> ((i%4)*8+4)) & 0xF) +
           hex_tab.charAt((binarray[i>>2] >> ((i%4)*8  )) & 0xF);
  }
  return str;
}

/*
* Convert an array of little-endian words to a base-64 string
*/
function binl2b64(binarray)
{
  var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  var str = "";
  for(var i = 0; i < binarray.length * 4; i += 3)
  {
    var triplet = (((binarray[i   >> 2] >> 8 * ( i   %4)) & 0xFF) << 16)
                | (((binarray[i+1 >> 2] >> 8 * ((i+1)%4)) & 0xFF) << 8 )
                |  ((binarray[i+2 >> 2] >> 8 * ((i+2)%4)) & 0xFF);
    for(var j = 0; j < 4; j++)
    {
      if(i * 8 + j * 6 > binarray.length * 32) str += b64pad;
      else str += tab.charAt((triplet >> 6*(3-j)) & 0x3F);
    }
  }
  return str;
}

    var submitForm = function(){

        var isValid = true;
        var msgForm = "";
        $('#messageStatus').html("");
        var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
        if(!emailReg.test($('#form-usuario [name=email]').val()) && $('#email').val() != ""){
            isValid = false;
        }
        if($('#form-usuario [name=email]').val() == ""){
            isValid = false;
            $('#form-usuario [name=email]').focus();
        }
        
        <?php if(empty($usuario)){ ?>
	        if(!emailReg.test($('#form-usuario [name=emailconfirma]').val()) && $('#form-usuario [name=emailconfirma]').val() != ""){
	            isValid = false;
	        }
	        if($('#form-usuario [name=email]').val() == ""){
	            isValid = false;
	        }
        <?php } ?>
        	
        if($('#form-usuario [name=nome]').val() == ""){
            isValid = false;
            $('#form-usuario [name=nome]').focus();
        }
        if($('#form-usuario [name=pessoa]').val() == ""){
            isValid = false;
        }
        if($('#form-usuario [name=cpf]').val() == ""){
            isValid = false;
        }
        if($('#form-usuario [name=nascimento]').val() == ""){
            isValid = false;
        }
        if($('#form-usuario [name=endereco]').val() == ""){
            isValid = false;
        }
        if($('#form-usuario [name=bairro]').val() == ""){
            isValid = false;
        }
        if($('#form-usuario [name=cidade]').val() == ""){
            isValid = false;
        }
        if($('#form-usuario [name=cep]').val() == ""){
            isValid = false;
        }
        if($('#form-usuario [name=uf]').val() == ""){
            isValid = false;
        }
		<?php if(empty($usuario)){ ?>
	        if($('#form-usuario [name=senha]').val() == ""){
	            isValid = false;
	        }
        <?php } ?>
        if(isValid){
            $('#form-usuario').ajaxSubmit({
                beforeSerialize: function() {
		            if($('#form-usuario [name=senha]').val()){
		                if($('#form-usuario [name=senha]').val() != $('#form-usuario [name=senhaconfirma]').val()){
		                    $('#messageStatus').html("<center><h4 class='color_red'>A confirmação de senha está diferente da senha. Digite novamente.</h4></center>");
		                    return false;
		                }
		                $('#form-usuario [name=senha]').val(hex_md5($('#form-usuario [name=senha]').val()));
		            }

                	},
                type:  'POST',
                url: "<?php echo base_url();?>usuario/salvar",
                success: function(resposta) { 
                    $('#form-usuario').html("<center><h4 class='color_green'>"+resposta+"</h4></center>");
                },
                error: function (xhr, ajaxOptions, thrownError){
                    //xhr.status : 404, 303, 501...
                    var error = null;
                    switch(xhr.status)
                    {
                        case "301":
                            error = "Erro de redirecionamento!";
                            break;
                        case "307":
                            error = "Erro, redirecionamento de servidor temporário!";
                            break;
                        case "400":
                            error = "Solicitação ruim!";
                            break;
                        case "404":
                            error = "Página não encontrada!";
                            break;
                        case "500":
                            error = "Servidor indisponível no momento!";
                            break;
                        default:
                            error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
                    }
                    if(error){
                        $('#messageStatus').html("<center><h4 class='color_red'>"+error+"</h4></center>");
                    }
                }
            });
        }
    };

$(document).ready(function() {
    $( "#pessoa" ).change(function () {
        var html = "";
        $( "select[id=pessoa] option:selected" ).each(function() {
          if ($( this ).val() == "F"){
                $( "#div-pessoa" ).html($( "#div-pessoa1" ).html());
                $('#cpf').mask('000.000.000-00');
          }else if ($( this ).val() == "J"){
                $( "#div-pessoa" ).html($( "#div-pessoa2" ).html());
                $('#cpf').mask('00.000.000/0000-00');
          }
        });
    }).change();
 
    var SPMaskBehavior = function (val) {
      return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
    },
    spOptions = {
      onKeyPress: function(val, e, field, options) {
          field.mask(SPMaskBehavior.apply({}, arguments), options);
        }
    };

    $('.telefone').mask(SPMaskBehavior, spOptions);
   
});

var starttime = function(url, count){
    var timer = $.timer(
            function() {
                    count--;
                    if(count>0){
                            $('.count').html(count);
                    }else if(count==0){
                            window.location = url;
                    }
            },
            1000,
            true
    );	
};

var checaEmail = function(){
    var isValid = true;
    var msgForm = "";
    $('#emailStatus').html(msgForm);
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    if(!emailReg.test($('#form-usuario [name=email]').val()) && $('#email').val() != ""){
        isValid = false;
        msgForm = "E-mail Inválido. Tente novamente.<br />";
    }
    if(isValid){
        var params = {
            'email' : $('#form-usuario [name=email]').val()
        };
        $.ajax({
            type: "POST",
            url: "<?php echo base_url(); ?>usuario/existeemail",
            data: params,
            success: function(response){
                if(response){
                    $('#emailStatus').html(response);
                    $( "#form-usuario [name=email]" ).focus();
                }
            }
        });
    }else{
    	$('#emailStatus').html(msgForm);
        $( "#form-usuario [name=email]" ).focus();
    }
};

var checaEmailConfirma = function(){
	$('#emailconfirmaStatus').html("");
    if($('#form-usuario [name=email]').val() && $('#form-usuario [name=emailconfirma]').val()){
        if($('#form-usuario [name=email]').val() != $('#form-usuario [name=emailconfirma]').val()){
            $('#emailconfirmaStatus').html("O e-mail de confiração deve ser o mesmo do e-mail. Verifique se o seu e-mail foi digitado corretamente. ");
            $( "#form-usuario [name=emailconfirma]" ).focus();
        }
    }

};

var checaCpf = function(){
    var isValid = true;
    var msgForm = "";
    $('#cpfStatus').html(msgForm);
    if($('#form-usuario [name=pessoa]').val() == "F"){
	    if($('#form-usuario [name=cpf]').val() == ""){
	        isValid = false;
	        msgForm = "Identificação é um campo obrigatório.<br />";
	    }
	    if(isValid){
	        var params = {
	            'cpf' : $('#form-usuario [name=cpf]').val()
	        };
	        $.ajax({
	            type: "POST",
	            url: "<?php echo base_url();?>usuario/existecpf",
	            data: params,
	            success: function(response){
	                if(response){
	                    $('#cpfStatus').html(response);
	                    $( "#cpf" ).focus();
	                }
	            }
	        });
	    }else{
	        $('#cpfStatus').html(msgForm);        
	        $( "#cpf" ).focus();
	    }    	
    }

};
</script>
