<!DOCTYPE html>
<html lang="pt-br" dir="ltr">

<?php $this->load->view('painel/incPainelHead'); ?>


<body class="layout-sticky-subnav layout-default ">

    <div class="preloader">
        <div class="sk-double-bounce">
            <div class="sk-child sk-double-bounce1"></div>
            <div class="sk-child sk-double-bounce2"></div>
        </div>
    </div>

    <!-- Header Layout -->
    <div class="mdk-header-layout js-mdk-header-layout">

<?php $this->load->view('painel/incPainelHeader'); ?>

        <!-- Header Layout Content -->
        <div class="mdk-header-layout__content page-content ">



            <div class="pt-32pt">
                <div class="container page__container d-flex flex-column flex-md-row align-items-center text-center text-sm-left">
                    <div class="flex d-flex flex-column flex-sm-row align-items-center mb-24pt mb-md-0">

                        <div class="mb-24pt mb-sm-0 mr-sm-24pt">
                            <h2 class="mb-0"><span class="material-icons sidebar-menu-icon sidebar-menu-icon--left" style="font-size: 33px !important; padding-bottom: 2px;">message</span>Suporte</h2><br />

                        </div>
                    </div>

                </div>
            </div>



            <div class="container page__container">
			
                        <?php if($this->session->userdata('id')) { ?>
                            <!--/ .page-header-->
                            Número do chamado: <?php echo $chamado[0]->id; ?><br/>
                            Data do chamado: <?php echo date("d/m/Y", strtotime($chamado[0]->data)); ?><br/>
                            Hora do chamado: <?php echo substr($chamado[0]->hora, 0, 5); ?><br/>
                            Status do chamado: <?php if($chamado[0]->status == '0'){echo "Pendente";}else{ echo "Respondido";} ?><br/>
                            Assunto: <?php echo $chamado[0]->assunto; ?><br/>
                            Mensagem: <?php echo $chamado[0]->mensagem; ?><br/><br/>
                            <?php if($chamado[0]->imagem){ ?>
                              	<a href="<?php echo base_url();?>iportal/public/biblioteca-de-arquivos/loja_suportechamado/<?php echo $chamado[0]->imagem ;?>" data-lightbox="<?php echo $chamado[0]->imagem ;?>">
                              		Anexo
                              	</a>
                            <?php } ?>
                            <?php if(empty($chamadolista)) { ?>
                                <div>
                                    Nenhuma resposta encontrada.<br/><br/>
                                </div>
                            <?php }else{ ?>
                                <h3>Mensagens</h3>
                                <?php foreach ($chamadolista as $key => $row) { ?>
                                    <?php if($key != 0) echo "<hr/>" ?>
                                    <div>
                                        <?php if($this->session->userdata('id') == $row->usuario){ ?>

                                            Data da mensagem: <?php echo date("d/m/Y", strtotime($row->data)); ?><br/>
                                            Hora da mensagem: <?php echo substr($row->hora, 0, 5); ?><br/>
                                            Mensagem do usuário: <?php echo $row->mensagem; ?><br/><br/>
                
                                            <?php if($row->imagem){ ?>
                                              	<a href="<?php echo base_url();?>iportal/public/biblioteca-de-arquivos/loja_suportechamado/<?php echo $row->imagem ;?>" data-lightbox="<?php echo $row->imagem ;?>">
                                              		<span class="material-icons sidebar-menu-icon sidebar-menu-icon--left">style</span>Anexo
                                              	</a><br/>
                                            <?php } ?>
                                        <?php } else { ?>

                                            Data da resposta: <?php echo date("d/m/Y", strtotime($row->data)); ?><br/>
                                            Hora da resposta: <?php echo substr($row->hora, 0, 5); ?><br/>
                                            Mensagem de resposta do suporte: <?php echo $row->mensagem; ?><br/><br/>
                                            
                                            <?php if($row->imagem){ ?>
                                              	<a href="<?php echo base_url();?>iportal/public/biblioteca-de-arquivos/loja_suportechamado/<?php echo $row->imagem ;?>" data-lightbox="<?php echo $row->imagem ;?>">
                                              		<span class="material-icons sidebar-menu-icon sidebar-menu-icon--left">style</span>Anexo
                                              	</a><br/>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                <!--/ .columns-->
                                <?php } ?>
                            <?php } ?>
                            <br/>
                            <h3>Nova Mensagem</h3>
                                <form id="form-mensagem" method="POST" action="<?php echo base_url();?>suporte/addMensagem" enctype="multipart/form-data">
                                    <input type="hidden" name="chamado" id="chamado" value="<?php echo $chamado[0]->id; ?>" />
                                	
                                    <div class="flex" style="max-width: 100%">
                                        <div class="was-validated">
            
                                            <div class="form-group">
                                                        <textarea class="form-control" name="mensagem" id="mensagem" placeholder="Mensagem" required=""></textarea>
                                                        <div class="invalid-feedback">Mensagem é um campo obrigatório.</div>
                                                        <div class="valid-feedback"></div>
                                            </div>
                                            
                                            <div class="media-body">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="imagem" name="imagem" accept="image/*">
                                                    <label class="custom-file-label" for="inputGroupFile01">Selecionar imagem</label>
                                                </div>
                                            </div>
                                            <br/>
                                            <button type="button" style="width: 100%; text-align: center;" class="btn btn-primary" href="javascript:void(0)" onClick="addMensagem()" id="submit">Enviar</button>
                                            
                                            <br /><br /><br />

                					    </div>
                					</div>
                				</form>	
                                <div id="messageMensagem"></div>
                                <?php }else{ ?>
                                    <center>É necessário estar logado para visualizar os chamados ou abrir um chamado.</center>
                                <?php } ?>   
                            </div>
                
                        </div>
                        <!-- // END Header Layout Content -->


<?php $this->load->view('painel/incPainelFooter'); ?>


    </div>
    <!-- // END Header Layout -->




<?php $this->load->view('painel/incPainelMenu'); ?>



<?php $this->load->view('painel/incPainelScripts'); ?>

</body>
</html>
<script>


var addMensagem = function(){
    var isValid = true;
    var msgForm = "";
    $('#mensagemStatus').html("");
    $('#messageMensagem').html(msgForm);
    if($('#form-mensagem [name=mensagem]').val() == ""){
        isValid = false;
        $('#form-mensagem [name=mensagem]').focus();
    }
    if(isValid){
        $('#form-mensagem').ajaxSubmit({
            beforeSerialize: function() {$("#submit").html("Enviando...");},
            dataType:  'json',
            url: "<?php echo base_url();?>suporte/addMensagem",
            success: function(resposta) { 
                $('#messageMensagem').html("<center><h4 class='color_green'>"+resposta['mensagem']+"</h4></center>");
                if(resposta['id']){
                    window.location = "<?php echo base_url($this->uri->segment(1));?><?php if($this->uri->segment(2)){ echo "/".$this->uri->segment(2); } ?><?php if($this->uri->segment(3)){ echo "/".$this->uri->segment(3); } ?>";
                }                    
            },
            error: function (xhr, ajaxOptions, thrownError){
                //xhr.status : 404, 303, 501...
                var error = null;
                switch(xhr.status)
                {
                    case "301":
                        error = "Erro de redirecionamento!";
                        break;
                    case "307":
                        error = "Erro, redirecionamento de servidor temporário!";
                        break;
                    case "400":
                        error = "Solicitação ruim!";
                        break;
                    case "404":
                        error = "Página não encontrada!";
                        break;
                    case "500":
                        error = "Servidor indisponível no momento!";
                        break;
                    default:
                        error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
                }
                if(error){
                    $('#messageMensagem').html("<center><h4 class='color_red'>"+error+"</h4></center>");
                    $(".jquery-waiting-base-container").waiting({modo:"slow"});
                }
            }
        });
    }
};
</script>