<?php

    class Produto extends MX_Controller {

			public function _remap($method){
				$this->my_configuracao->confSess();
			    if($method == 'index'){
			        $this->index();
			    }elseif($method == 'categoria'){
			        $this->categoria($this->uri->segment(3));
			    }elseif($method == 'id'){
			        $this->id($this->uri->segment(3), $this->uri->segment(4));
			    }elseif($method == 'cupom'){
			        $this->cupom();
			    }elseif($method == 'frete'){
			        $this->frete();
			    }elseif($method == 'validacpf'){
			        $this->validacpf();
			    }else{
			    	  $this->id($method);
			    }
			}

	    function index($filiacao=''){
	
	        $this->load->model('produtomodel', 'modelo');
	        if($this->input->post('porpagina')){
	            $data['porpagina'] = $this->input->post('porpagina');
	        }else{
	            $data['porpagina'] = 9;
	        }            
	        if($this->input->post('ordenacao')){
	            $data['ordenacao'] = $this->input->post('ordenacao');
	        }else{
	            $data['ordenacao'] = "promocao desc";
	        }
			$data['filiacao'] = $this->modelo->filiacao($filiacao);
			if(!empty($data['filiacao']) && $data['quantreg'] == '1'){
				redirect(base_url()."produto/id/".$lista[0]->id."/".$filiacao);
			}
			$data['listacategoria'] = $this->modelo->listacategoria();
			$data['categoria'] = '';
	        $this->load->view('produtoview', $data);
	    }
	
	    function id($id, $filiacao=''){
	    	$html_pagamentoforma = "";
	        $this->load->model('produtomodel', 'modelo');
	        $data['confIntegracao'] = $this->my_configuracao->confIntegracao();
	        $produto = $this->modelo->produto($id);
	        $id = $produto[0]->id;
	        $this->modelo->autualizaVendas($produto[0]->id);
	        //$produto = $this->modelo->produto($id);
            $token = md5(time());
            $data['token'] = $token;
            $this->session->set_userdata('token',$token);
	        if(empty($produto)){
	            redirect(base_url().'produto');
	        }
	      if($produto[0]->tipo == '5') {
	      	if($produto[0]->qtdade_saldo > 0) {
	      		$combo_vendidos = $this->modelo->combo_vendidos($id);
		      	if(empty($combo_vendidos[0]->qtdade_saldo)) {
		      		$produto[0]->qtdade_saldo = 0;
		      	} else {
		      		$produto[0]->qtdade_saldo = $combo_vendidos[0]->qtdade_saldo;
		      	}
	      	}
	      	$listaproduto_combo = '';
	      } else {
		      $vendidos_combo = $this->modelo->vendidos_combo($id);
		      $produto[0]->qtdade_saldo = $produto[0]->qtdade_saldo-$vendidos_combo[0]->qtdade_saldo;
		      $data['listaproduto_combo'] = $this->modelo->listaproduto_combo($vendidos_combo[0]->id);
		      
	      }
			$compra_unica = $this->modelo->compra_unica($produto[0]->id);
			$carrinho_compra_unica = $this->modelo->carrinho_compra_unica();
			if((!empty($compra_unica) || !empty($carrinho_compra_unica)) && $this->session->userdata('id')) {
				$this->modelo->limpaCarrinho($id);
			}
			$data['descricao_resumo'] = $this->limitarTexto($produto[0]->descricao,500);
			$data['produto'] = $produto;
			$data['cursomodulo'] = $this->modelo->cursomodulo($produto[0]->curso);
			$data['homedescricao'] = $this->modelo->homedescricao();
			$data['destaqueprincipal'] = $this->modelo->destaqueprincipal();
			$data['destaqueprincipal_produto'] = $this->modelo->destaqueprincipal_produto($data['destaqueprincipal'][0]->url_amigavel);
            $data['cursodepoimento'] = $this->modelo->cursodepoimento();
			$data['garantias'] = $this->modelo->garantias();
			$data['faq'] = $this->modelo->faq();
	        $data['listacupom'] = $this->modelo->listacupom($produto[0]->id);
	        $data['produtofoto'] = $this->modelo->produtofoto($produto[0]->id);
	        $data['unidade'] = $this->modelo->unidade($produto[0]->id, $produto[0]->carunidade);
	        $data['formulario'] = $this->modelo->formulario($produto[0]->categoriaid);
	        $lista_pagamentoforma = $this->modelo->lista_pagamentoforma($produto[0]->id);
			$data['html_pagamentoforma'] = '';
			foreach ($lista_pagamentoforma as $key => $row) {
				$data['html_pagamentoforma'] .= '<option value="'.$row->id.'">'.$row->descricao.' R$ '.number_format($produto[0]->preco, 2, ',', '').'</option>';
			}
			$data['uf'] = $this->modelo->uf();
			$data['filiacao'] = $this->modelo->filiacao($filiacao, $produto[0]->id);
			$comprado_usuarios = '';
			$produto_comprado_usuario = $this->modelo->produto_comprado_usuario($produto[0]->id);
	      foreach ($produto_comprado_usuario as $key => $row) {
	      	if($key != '0') { $comprado_usuarios .= ','; }
	      	$comprado_usuarios .= $row->usuario;
	      }
	      if(!empty($produto_comprado_usuario)) {
	      	$data['produto_comprado'] = $this->modelo->produto_comprado($comprado_usuarios, $produto[0]->id);
	   	}
	      $this->load->view('produtoidview', $data);
	    }
	    
	    function categoria($categoria){
	
	        $this->load->model('produtomodel', 'modelo');
	        if($this->input->post('porpagina')){ 
	            $data['porpagina'] = $this->input->post('porpagina');
	        }else{
	            $data['porpagina'] = 8;
	        }            
	        if($this->input->post('ordenacao')){ 
	            $data['ordenacao'] = $this->input->post('ordenacao');
	        }else{
	            $data['ordenacao'] = "promocao desc";
	        }            
	        $data['quantreg'] = count($this->modelo->lista($categoria));
	        $data['lista'] = $this->modelo->lista($categoria, $data['ordenacao']);
			$data['listacategoria'] = $this->modelo->listacategoria($categoria);
			$data['categoria'] = $categoria;
	        $this->load->view('produtoview', $data);
	    }
	
	    function cupom(){
			$data['mensagem'] = '';
			$data['desconto'] = 0;
			$data['acrescimo'] = 0;
			$data['descontocupom'] = '';
			$data['precosemdesconto'] = 0;
	      $this->load->model('produtomodel', 'modelo');
			if($this->input->post('unidade')){
				$produto = $this->modelo->produtounidade($this->input->post('produto'), $this->input->post('unidade'));
			}else{
				$produto = $this->modelo->produto($this->input->post('produto'));
			}
			$cupom = $this->modelo->cupom($this->input->post('cupom'), $this->input->post('produto'));
			$data['preco'] = $produto[0]->preco;
	
			if(empty($cupom)){
				if($this->input->post('cupom')){
						$data['mensagem'] = "<center><h4 class='color_red'>Cupom inválido.</h4></center>";
	        	}
			}else{
				$data['qtdade_disponivel'] = $cupom[0]->qtdade - $cupom[0]->utilizado;
				if($this->input->post('qtdade') > $data['qtdade_disponivel']){
					$data['mensagem'] = "<center><h4 class='color_red'>Há somente ".$data['qtdade_disponivel']." cupons de desconto disponíveis.</h4></center>";
				}else{
					$data['preco'] = ($produto[0]->preco - $cupom[0]->desconto);
					$data['precosemdesconto'] = $produto[0]->preco;
					$data['descontocupom'] = $cupom[0]->desconto;
				}
			}
			$desconto = 0;
			$acrescimo = 0;
			if($this->input->post('pagamentoforma')){
		      $pagamentoforma = $this->modelo->pagamentoforma($this->input->post('pagamentoforma'), $this->input->post('produto'));
		      $lista_pagamentoforma = $this->modelo->lista_pagamentoforma($this->input->post('produto'));
				$data['html_pagamentoforma'] = '';
				foreach ($lista_pagamentoforma as $key => $row) {
					if($row->id == $this->input->post('pagamentoforma')){
						$selecione = "selected ";
					}else{
						$selecione = "";
					}
					
					if($row->tipodesacr == '1'){
						$desconto = ($data['preco']*($row->desacr/100));
						$acrescimo = 0;
					}elseif($row->tipodesacr == '2'){
						$desconto = $row->desacr;
						$acrescimo = 0;
					}elseif($row->tipodesacr == '3'){
						$acrescimo = ($data['preco']*($row->desacr/100));
						$desconto = 0;
					}elseif($row->tipodesacr == '4'){
						$acrescimo = $row->desacr;
						$desconto = 0;
					}else{
						$desconto = 0;
						$acrescimo = 0;
					}
					
					$valor = ($data['preco']-$desconto+$acrescimo)*$this->input->post('qtdade');
					if($row->tipo == 'C'){
						$valor_parcela = $valor/$row->qtde_parcelas;
						$data['html_pagamentoforma'] .= '<option '.$selecione.'value="'.$row->id.'">'.$row->descricao.' R$ '.number_format($valor_parcela, 2, ',', '').' => total R$ '.number_format($valor, 2, ',', '').'</option>';
					}else{
						$data['html_pagamentoforma'] .= '<option '.$selecione.'value="'.$row->id.'">'.$row->descricao.' R$ '.number_format($valor, 2, ',', '').'</option>';
					}
				}
				if($pagamentoforma[0]->tipodesacr == '1'){
					$data['desconto'] = ($data['preco']*($pagamentoforma[0]->desacr/100));
				}elseif($pagamentoforma[0]->tipodesacr == '2'){
					$data['desconto'] = $pagamentoforma[0]->desacr;
				}elseif($pagamentoforma[0]->tipodesacr == '3'){
					$data['acrescimo'] = ($data['preco']*($pagamentoforma[0]->desacr/100));
				}elseif($pagamentoforma[0]->tipodesacr == '4'){
					$data['acrescimo'] = $pagamentoforma[0]->desacr;
				}
		   }
	
			$data['preco'] = $data['preco']-$data['desconto']+$data['acrescimo'];
			$data['total'] = $data['preco']*$this->input->post('qtdade');
			echo json_encode($data);
	    }
	
	    function frete(){
			$data['mensagem'] = '';
			$resultado = false;
			$valorfrete = 0;    	
	        $this->load->model('produtomodel', 'modelo');
	        $produto = $this->modelo->produto($this->input->post('produto'));
	        $frete = $this->modelo->buscaFrete($this->input->post('cep'), $this->input->post('produto'));
			if(empty($frete)){
				$data['mensagem'] = "<center><h4 class='color_red'>Não há disponibilidade de frete para este CEP.</h4></center>";
			}else{
				if($produto[0]->tipo_frete == '1'){
					$valorfrete = $frete[0]->valor;
					$resultado = true;
				}elseif($produto[0]->tipo_frete == '2'){
					$resultado = true;
					$data['mensagem'] = "<center><h4 class='color_green'>Frete grátis para este produto.</h4></center>";
				}
			}
			$data['resultado'] = $resultado;
			$data['valor'] = $valorfrete;
			
			echo json_encode($data);
	    }
	
	    function validacpf(){
	        $retorno = "";
	        $this->load->model('produtomodel', 'modelo');
			if(!$this->modelo->validaCPF($this->input->post('cpf'))){
	            $retorno = "Este CPF é inválido.";
	        }
	        echo $retorno;        
	    } 
	
	    function tofloat($num) {
	        $dotPos = strrpos($num, '.');
	        $commaPos = strrpos($num, ',');
	        $sep = (($dotPos > $commaPos) && $dotPos) ? $dotPos : 
	            ((($commaPos > $dotPos) && $commaPos) ? $commaPos : false);
	
	        if (!$sep) {
	            return floatval(preg_replace("/[^0-9]/", "", $num));
	        } 
	
	        return floatval(
	            preg_replace("/[^0-9]/", "", substr($num, 0, $sep)) . '.' .
	            preg_replace("/[^0-9]/", "", substr($num, $sep+1, strlen($num)))
	        );
	    }
	
		function limitarTexto($texto, $limite = 100){
			$contador = mb_strlen($texto);
			if ( $contador >= $limite ) {
				$texto = mb_substr($texto, 0, mb_strrpos(mb_substr($texto, 0, $limite), ' '), 'UTF-8') . '...';
				return $texto;
			}
			else{
				return $texto;
			}
		}
	
	}





