<?php

class Painelmodel extends CI_Model {

    function __construct(){
        // Chama o construtor do Model
        parent::__construct();
    }

    public function meuscursos($tipo=''){
    	$sql = "SELECT crs.*, DATE_ADD(pdd.data, INTERVAL crs.periodicidade DAY) data_expiracao
    	   FROM curso crs
			INNER JOIN produto prd ON prd.curso = crs.id
			INNER JOIN pedidoitem pdi ON pdi.produto = prd.id
			INNER JOIN pedido pdd ON pdd.id = pdi.pedido
			WHERE pdd.usuario = '".$this->session->userdata('id')."'
			AND (crs.tipo = '$tipo' or '$tipo' = '')
			AND ((crs.status = '1'
			AND pdi.status = '1'
			AND pdd.status NOT IN ('2','6','7'))
			or pdi.gratis = '1')
			GROUP BY crs.id
			ORDER BY crs.titulo";
		//echo "<pre>";
		//echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }
    
    public function meuscursos_expiracao($curso){
    	$sql = "SELECT crs.*, IFNULL(crs.data_expiracao, if(crs.periodicidade = '-1', null, DATE_ADD(pdd.data, INTERVAL crs.periodicidade DAY))) data_expiracao
    	    FROM curso crs
			INNER JOIN produto prd ON prd.curso = crs.id
			INNER JOIN pedidoitem pdi ON pdi.produto = prd.id
			INNER JOIN pedido pdd ON pdd.id = pdi.pedido
			WHERE crs.id = '$curso'
			order by pdd.data desc";
		//echo "<pre>";
		//echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }
    
    public function curso($url_amigavel){
    	$sql = "SELECT crs.*, DATE_ADD(pdd.data, INTERVAL crs.periodicidade DAY) data_expiracao
         FROM curso crs
			INNER JOIN produto prd ON prd.curso = crs.id
			INNER JOIN pedidoitem pdi ON pdi.produto = prd.id
			INNER JOIN pedido pdd ON pdd.id = pdi.pedido
			LEFT JOIN cursomodulo csm on csm.curso = crs.id
			LEFT JOIN cursovideoaula cvd on cvd.modulo = csm.id
			WHERE pdd.usuario = '".$this->session->userdata('id')."'
			and crs.url_amigavel = '$url_amigavel'
			AND ((crs.status = '1'
			AND pdi.status = '1'
			AND pdd.status NOT IN ('2','6','7'))
			or pdi.gratis = '1')
			GROUP BY crs.id
			ORDER BY pdd.data desc";
		//echo "<pre>";
		//echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function cursopercentual($curso){
    	$sql = "SELECT csm.curso, CEILING((sum(cvd.tempo)/10000)/60) somatempo, CEILING((sum(if(csp.usuario,cvd.tempo,'00:00:00'))/10000)/60) presenca
            FROM cursovideoaula cvd
				inner JOIN cursomodulo csm on csm.id = cvd.modulo
            left join cursopresenca csp on csp.videoaula = cvd.id and csp.usuario = '".$this->session->userdata('id')."'
            where csm.curso = '$curso'";
		//echo "<pre>";
		//echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function modulos($curso){
    	$sql = "SELECT csm.*, crs.id cursoid, crs.titulo cursonome, DATE_ADD(pdd.data, INTERVAL crs.periodicidade DAY) data_expiracao, COUNT(cvd.id) videoaulacont
			FROM cursomodulo csm
			INNER JOIN curso crs ON crs.id = csm.curso
			INNER JOIN produto prd ON prd.curso = crs.id
			INNER JOIN pedidoitem pdi ON pdi.produto = prd.id 
			INNER JOIN pedido pdd ON pdd.id = pdi.pedido
			INNER JOIN cursovideoaula cvd ON cvd.modulo = csm.id
			and cvd.status = '1'
			WHERE crs.id = '$curso'
			AND pdd.usuario = '".$this->session->userdata('id')."'
			AND (curdate() <= DATE_ADD(pdd.data, INTERVAL crs.periodicidade DAY) or crs.periodicidade = '-1')
			AND csm.status = '1'
			AND crs.status = '1'
			AND pdi.status = '1'
			AND pdd.status NOT IN ('2','6','7')
			GROUP BY csm.id
			order by csm.ordem";
		//echo "<pre>";
		//echo $sql;
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function videoaulalista($modulo){
        $sql = "SELECT cvd.*, csp.videoaula presenca, crs.id cursoid, crs.titulo cursonome, csm.nome molulonome, csm.id moduloid, DATE_ADD(pdd.data, INTERVAL crs.periodicidade DAY) data_expiracao
			FROM cursovideoaula cvd
			INNER JOIN cursomodulo csm ON csm.id = cvd.modulo
			INNER JOIN curso crs ON crs.id = csm.curso
			INNER JOIN produto prd ON prd.curso = crs.id
			INNER JOIN pedidoitem pdi ON pdi.produto = prd.id 
			INNER JOIN pedido pdd ON pdd.id = pdi.pedido
			LEFT JOIN cursopresenca csp on csp.videoaula = cvd.id
			WHERE csm.id = '$modulo'
			AND pdd.usuario = '".$this->session->userdata('id')."'
			AND cvd.status = '1'
			AND csm.status = '1'
			AND crs.status = '1'
			AND pdi.status = '1'
			AND pdd.status NOT IN ('2','6','7')
			GROUP BY cvd.id
			ORDER BY cvd.ordem";
        $query = $this->db->query($sql);
		//echo "<pre>";
		//echo $sql;
        return $query->result();
    }

    public function videoaula($videoaula){
    	$sql = "SELECT distinct cvd.*, crs.id cursoid, crs.titulo cursonome, crs.tipo, csm.nome molulonome, csm.id moduloid, DATE_ADD(pdd.data, INTERVAL crs.periodicidade DAY) data_expiracao, crs.url_amigavel crsurl_amigavel 
			FROM cursovideoaula cvd
			INNER JOIN cursomodulo csm ON csm.id = cvd.modulo
			INNER JOIN curso crs ON crs.id = csm.curso
			INNER JOIN produto prd ON prd.curso = crs.id
			INNER JOIN pedidoitem pdi ON pdi.produto = prd.id 
			INNER JOIN pedido pdd ON pdd.id = pdi.pedido
			WHERE cvd.id = '$videoaula'
			AND pdd.usuario = '".$this->session->userdata('id')."'
			AND cvd.status = '1'
			AND csm.status = '1'
			AND crs.status = '1'
			AND pdi.status = '1'
			AND pdd.status NOT IN ('2','6','7')
			ORDER BY cvd.ordem";
        $query = $this->db->query($sql);
		//echo "<pre>";
		//echo $sql;
        return $query->result();
    }  

    public function chat($videoaula){
    	$sql = "SELECT *, usu.nome
			FROM curso_chat cht
			inner join adminacesso usu on usu.id = cht.usuario
			WHERE cht.videoaula = '$videoaula'
			ORDER BY cht.datahora";
        $query = $this->db->query($sql);
		//echo "<pre>";
		//echo $sql;
        return $query->result();
    } 

    public function download($videoaula){
        $query = $this->db->query("SELECT DISTINCT crs.titulo cursonome, csm.nome modulonome, cvd.titulo videoaulanome, csd.*
			FROM cursodown csd
			INNER JOIN cursovideoaula cvd ON cvd.id = csd.videoaula
			INNER JOIN cursomodulo csm ON csm.id = cvd.modulo
			INNER JOIN curso crs ON crs.id = csm.curso
			INNER JOIN produto prd ON prd.curso = crs.id
			INNER JOIN pedidoitem pdi ON pdi.produto = prd.id 
			INNER JOIN pedido pdd ON pdd.id = pdi.pedido
			WHERE (curdate() <= DATE_ADD(pdd.data, INTERVAL crs.periodicidade DAY) or crs.periodicidade = '-1')
			AND pdd.usuario = '".$this->session->userdata('id')."'
			AND cvd.id = '$videoaula'
			AND csd.status = '1'
			AND cvd.status = '1'
			AND csm.status = '1'
			AND crs.status = '1'
			AND pdi.status = '1'
			AND pdd.status NOT IN ('2','6','7')");
        return $query->result();        
    }

    public function meuspedidos(){
        $query = $this->db->query("SELECT pdi.*, prd.titulo produtonome, prd.evento, pes.nome statusnome, prd.capa, prd.tipo, prd.arquivo, paf.descricao pagamentonome, ped.id pedid
			FROM pedidoitem pdi
			inner join pedido ped on ped.id = pdi.pedido
            INNER JOIN produto prd ON prd.id = pdi.produto
            INNER JOIN pedido_status pes ON pes.id = ped.status
            LEFT JOIN pagamentoforma paf ON paf.id = ped.pagamentoforma
            WHERE ped.usuario = '".$this->session->userdata('id')."' 
            ORDER BY ped.id DESC");
        return $query->result();        
    }

    public function marcarpresenca(){
        $retorno = false;
        $this->db->set('videoaula', $this->input->post('video'));
        $this->db->set('usuario', $this->session->userdata('id'));
        $this->db->set('datahora', date('Y-m-d H:i:s'));
        if($this->db->insert('cursopresenca')){
            $retorno = true;
        }
        return $retorno;
    }
    
	public function adicionarchat(){
		$this->db->set('videoaula', $this->input->post('videoaula'));     
		$this->db->set('usuario', $this->session->userdata('id'));   
		$this->db->set('mensagem', $this->input->post('mensagem'));
		$this->db->set('datahora', date('Y-m-d H:i:s'));
		$this->db->insert('curso_chat');
    }
    
    public function pedidoPixPendente(){
        $query = $this->db->query("SELECT * FROM pedido 
            where usuario = '".$this->session->userdata('id')."'
            and status = '9'");
        return $query->result();        
    }
}
