<!doctype html>
<html lang="pt-br">

<?php $this->load->view('includes/incHead'); ?>

<body>

    <div class="page-container">


<?php $this->load->view('includes/incHeader'); ?>


<main class="main-container">
    <div class="content-container page-contact">
        <div class="page-title-container" id="particles-js">
            <h1 class="title">Dados do cartão</h1>
            <p class="title-description"></p>
        </div>
         <div class="page-contact-structure">
         	
        <br />
  


		<div class="sixteen columns">


				<?php if($carrinho[0]->cursoid && $carrinho[0]->cursotipo == '1') { ?>
				<h3><span class="nome-evento-galeria color_green">
					Após a confirmação do pagamento, será enviado um e-mail para acesso ao curso. <br/>
					Se preferir, você poderá utilizar o link "Meus cursos" localizado na área "Restrito".
				</span></h3>
				<?php } ?>
			</div>
			<!--/ .page-header-->
			
		<div class="sixteen columns">
			
        Seguem abaixo os dados da sua compra na loja <?php echo $this->session->userdata('nome_projeto'); ?>:<br/><br/>
        <strong>Forma de pagamento selecionada:</strong> <?php echo $pagamentoforma[0]->descricao; ?> 
        <?php 
        $valortotal = floatval($pagamentoTotal[0]->total);
        	if($pagamentoforma[0]->tipo == 'C'){
        		$valor_parcela = floatval($valortotal/$pagamentoforma[0]->qtde_parcelas);
				echo "R$ ".str_replace(".", ",", number_format($valor_parcela,2,',','')).'</option>';
        	}else{
        		echo "R$ ".str_replace(".", ",", number_format($valortotal,2,',',''));
        	} 
        ?>

        <br/>
        <?php if($pagamentoTotal[0]->totalfrete > 0) { ?>
	        <strong>Valor total de produtos:</strong> R$ <?php echo number_format(floatval($pagamentoTotal[0]->total)); ?><br/>
	        <strong>Taxa de entrega:</strong> R$ <?php echo number_format($pagamentoTotal[0]->totalfrete,2,',',''); ?><br/>
    	<?php } ?>
        <strong>Valor total a pagar:</strong> R$ <?php echo number_format($valortotal,2,',',''); ?><br/><br/>
        
		Seguem abaixo os dados dos itens:<br/><br/>	
		
                        <table style="width: 100%; border: 2px; border-color: red;">
                            <thead style="text-align: left;">
                                <tr>
                                    <th>
                                        Produto
                                    </th>
                                    <th>
                                        Quantidade
                                    </th>
                                    <th>
                                        Valor unitário
                                    </th>
                                    <th>
                                        Total do item
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($carrinho as $row) { ?>
                                <tr>
                                    <td>
                                        <?php echo $row->titulo; ?>
                                    </td>
                                    <td>
                                    	<?php echo $row->qtdade; ?>
                                    </td>
                                    <td>
                                        R$ <?php echo str_replace(".", ",", $row->valorunitario); ?>
                                    </td>
                                    <td>
                                        R$ <?php echo str_replace(".", ",", $row->valor); ?>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                        <br /><br />

                    <form id="form-pagamento" class="contact-form tw-form" method="POST" action="<?php echo base_url();?>pagamento/pedido" enctype="multipart/form-data">
                            <input type="hidden" name="token" id="token" value="<?php echo $token; ?>" />  
                            <input type="hidden" name="forma_pagamento" id="forma_pagamento" value="<?php echo $this->input->post('pagamentoforma');?>" />
                            <input type="hidden" name="produto" id="produto" value="<?php echo $this->input->post('produto');?>" />
                            <input type="hidden" name="carrinho" id="carrinho" value="<?php echo $this->input->post('carrinho');?>" />
                            
                            <div class="form-input-container">  
                            <select style="width: 100%;" class="form-input" name="bandeira" id="bandeira">
                            	<?php if($this->input->post('pagamentoforma') == '1') { ?>
	                                <option value="visa">Visa Electron</option>
	                                <option value="mastercard">Maestro</option>
                                <?php }else{ ?>
	                                <option value="visa">Visa</option>
	                                <option value="mastercard">MasterCard</option>
	                                <option value="diners">Diners</option>
	                                <option value="discover">Discover</option>
	                                <option value="elo">Elo</option>
	                                <option value="jcb">JCB</option>
	                                <option value="aura">Aura</option>
	                                <option value="amex">American express</option>
	                                <option value="hipercard">Hipercard</option>
                                <?php } ?>
                            </select>
                            <label>Bandeira</label>
                            </div>
                        	<span class="mensagem-alerta" id="emailStatus"></span><br/>
                        	
                        	<div class="form-input-container">
                            <input type="text" style="width: 99%;" class="form-input cartao_nome" onclick="showImagemCartao('nome')" name="nome_titular" id="nome_titular" maxlength="100"  autocomplete="off" />
                            <label for="nome_titular">Nome (como está no cartão)</label>
                            </div>
                        	<span class="mensagem-alerta" id="nome_titularStatus"></span><br/>
                        	
                        	<div class="form-input-container">
                            <input type="text" style="width: 99%;" class="form-input cartao_numero" onclick="showImagemCartao('numero')" name="numero_cartao" id="numero_cartao" maxlength="16"  autocomplete="off" />
                            <label for="numero_cartao">Número do cartão</label>
                            </div>
                        	<span class="mensagem-alerta" id="numero_cartaoStatus"></span><br/>
                        	
                        	<div class="form-input-container">
                            <input type="text" style="width: 99%;" class="form-input cartao_cvv" onclick="showImagemCartao('cvv')" name="codigo_cartao" id="codigo_cartao" maxlength="3"  autocomplete="off" />
                            <label for="codigo_cartao">Código CVV</label>
                            </div>
                        	<span class="mensagem-alerta" id="codigo_cartaoStatus"></span><br/>
                        	
                        	<div class="form-input-container">
                            <input type="text" style="width: 99%;" class="form-input cartao_validade" onclick="showImagemCartao('validade')" name="data_vencimento" id="data_vencimento" maxlength="6"  autocomplete="off" />
                            <label for="data_vencimento">Validade (mm/aa)</label>
                            </div>
                        	<span class="mensagem-alerta" id="data_vencimentoStatus"></span><br/>
                        	
                        	<br/>
                            <p class="form-submit">
                                <input type="button" value="Concluir pagamento" style="width: 100%" id="submit-pagamento" class="tw-btn default upper bold"/>
                                <!--input type="submit" value="Concluir pagamento" style="width: 100%" id="submit-pagamento" class="btn"/-->
                            </p>
	                    <a class="tw-btn default upper bold" href="<?php echo $_SERVER['HTTP_REFERER']; ?>"> <<<< Voltar </a>
                    </form>

                    <div id="messageStatus"></div>
                    <div id="timerstart" style="display: none;"></div>
                    <!--/ .contact-form--> 
		</div>

    </div>    
   </div>
</main>

<?php $this->load->view('includes/incFooter'); ?>

            </div>

<?php $this->load->view('includes/incScripts'); ?>

<script>

var showImagemCartao = function(campo){
	$( ".cartao_nome" ).hideBalloon();
	$( ".cartao_numero" ).hideBalloon();
	$( ".cartao_cvv" ).hideBalloon();
	$( ".cartao_validade" ).hideBalloon();

	$(".cartao_"+campo).showBalloon({
		  position: "top",
		  html: true,
		  contents: '<img width="200px" src="<?php echo base_url();?>public/images/'+$('#bandeira').val()+'_'+campo+'.jpg" />'
	});
/*
	$( "#cartao_nome" ).html("");
	$( "#cartao_numero" ).html("");
	$( "#cartao_cvv" ).html("");
	$( "#cartao_validade" ).html("");

   	$( "#cartao_"+campo ).html('<img width="200px" src="<?php echo base_url();?>public/images/'+$('#bandeira').val()+'_'+campo+'.jpg" />');
   	$( "#cartao_"+campo ).show();
*/   	
};

var ResetInput = function(){
    	$('#nome_titular').val("");
        $('#numero_cartao').val("");
        $('#codigo_cartao').val("");
        $('#data_vencimento').val("");
};

$(document).ready(function() {
    $("#submit-pagamento").click(function(){
    	$('#nome_titularStatus').html("");
        $('#numero_cartaoStatus').html("");
        $('#codigo_cartaoStatus').html("");
        $('#data_vencimentoStatus').html("");
        var isValid = true;
        var msgForm = "";
        $('#messageStatus').html(msgForm);
        if($('#form-pagamento [name=nome_titular]').val() == ""){
            isValid = false;
            $('#nome_titularStatus').html("Nome do titular é obrigatório.<br />");
        }
        if($('#form-pagamento [name=numero_cartao]').val() == ""){
            isValid = false;
            $('#numero_cartaoStatus').html("Número do cartão é obrigatório.<br />");
        }
        if($('#form-pagamento [name=codigo_cartao]').val() == ""){
            isValid = false;
            $('#codigo_cartaoStatus').html("Código do cartão é obrigatório.<br />");
        }
        if($('#form-pagamento [name=data_vencimento]').val() == ""){
            isValid = false;
            $('#data_vencimentoStatus').html("Validade é obrigatório. Formatação da validade mm/aaaa<br />");
        }
        if(isValid){
        	$( ".cartao_nome" ).hideBalloon();
        	$( ".cartao_numero" ).hideBalloon();
        	$( ".cartao_cvv" ).hideBalloon();
        	$( ".cartao_validade" ).hideBalloon();
            $('#form-pagamento').ajaxSubmit({
                beforeSerialize: function() {$(".jquery-waiting-base-container").waitingShow({modo:"slow"});},
                dataType:  'json',
                url: "<?php echo base_url();?>pagamento/pedido",
                success: function(resposta) { 
                	//alert(resposta['mensagem']);
                    if(resposta['resultado']){
                        $('#form-pagamento').html("<center><h4 class='color_green'>"+resposta['mensagem']+"</h4></center>");
                        $('#form-pagamento').show();   
                        $('#timerstart').show();
                    	if(resposta['status'] == '6'){
                    		<?php if(!$this->session->userdata('id') && $this->input->post('carrinho')){ ?>
                    			window.open('<?php echo base_url();?>ticket/pdf/'+resposta['pedido'], '_blank ');
                			<?php } ?>
                    		starttime('<?php echo base_url().'painel'; ?>', 5);
            				$('#timerstart').html("<center><h6>Você está sendo redirecionado a área do aluno em <span class='count'>5</span> segundos.</h6></center>");
                    	}else{
                    		starttime(resposta['url_autenticacao'], 10);
            				$('#timerstart').html("<center><h6>Você está sendo redirecionado para o site do seu banco em <span class='count'>10</span> segundos.</h6></center>");
                    	}
                    }else{
                    	if(resposta['url_autenticacao']){
                    		starttime(resposta['url_autenticacao'], 10);
                    	}
                        $('#messageStatus').html("<center><h4 class='color_red'>"+resposta['mensagem']+"</h4></center>");
                        $('#messageStatus').show();   
                    }
                	ResetInput();
                    $(".jquery-waiting-base-container").waiting({modo:"slow"});
                },
                error: function (xhr, ajaxOptions, thrownError){
                    //xhr.status : 404, 303, 501...
                    var error = null;
                    switch(xhr.status)
                    {
                        case "301":
                            error = "Erro de redirecionamento!";
                            break;
                        case "307":
                            error = "Erro, redirecionamento de servidor temporário!";
                            break;
                        case "400":
                            error = "Solicitação ruim!";
                            break;
                        case "404":
                            error = "Página não encontrada!";
                            break;
                        case "500":
                            error = "Servidor indisponível no momento!";
                            break;
                        default:
                            error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
                    }
                    if(error){
                        $('#messageStatus').html("<center><h4 class='color_red'>"+error+"</h4></center>");
                        $(".jquery-waiting-base-container").waiting({modo:"slow"});
	                    ResetInput();
                    }
                }
            });
        }else{
        	$('#messageStatus').html("<center><h4 class='color_red'>"+msgForm+"</h4></center>");
            $(".jquery-waiting-base-container").waiting({modo:"slow"});
        }
    });

  
    $(function() {
        $.mask.definitions['~'] = "[+-]";
        $("#data_vencimento").mask("99/99");
    });   

    $( "#bandeira" ).change(function () {
    	$.mask.definitions['~'] = "[+-]";
		if($("#bandeira").val() == 'visa'){
			$("#numero_cartao").mask("0000000000000999");
        	$("#codigo_cartao").mask("999");
		}else if($("#bandeira").val() == 'diners'){
			$("#numero_cartao").mask("00000000000000");
        	$("#codigo_cartao").mask("000");
		}else if($("#bandeira").val() == 'amex'){
			$("#numero_cartao").mask("000000000000000");
        	$("#codigo_cartao").mask("0000");
		}else if($("#bandeira").val() == 'aura'){
			$("#numero_cartao").mask("0000000000000000999");
        	$("#codigo_cartao").mask("000");
		}else{
			$("#numero_cartao").mask("0000000000000000999");
        	$("#codigo_cartao").mask("000");
		}
    }).change();



    var starttime = function(url, count){
        var timer = $.timer(
                function() {
                        count--;
                        if(count>0){
                                $('.count').html(count);
                        }else if(count==0){
                                window.location = url;
                        }
                },
                1000,
                true
        );	
    };
    
});

</script>

</body>
</html>