<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

    class Pagamento extends MX_Controller {
        
        function index(){
            $this->load->model('pagamentomodel', 'modelo');
			$produto = $this->modelo->produto($this->input->post('produto'));
			if(empty($produto[0]->usuariooff)){
				$this->my_acesso->logged();
			}
			$this->my_configuracao->confSess();
			$data['confIntegracao'] = $this->my_configuracao->confIntegracao();
            $token = md5(time());
            $data['token'] = $token;
            $this->session->set_userdata('token',$token);
            
            $carrinho = $this->modelo->carrinho($this->session->userdata('id'), $this->input->post('carrinho'));
            if(empty($carrinho)){
                redirect(base_url(), 'refresh');
            }
			$data['carrinho'] = $carrinho;
            $data['pagamentoTotal'] = $this->modelo->pagamentoTotal($this->session->userdata('id'), $this->input->post('carrinho'));      
            $data['pagamentoforma'] = $this->modelo->pagamentoforma($this->input->post("pagamentoforma"));
            $this->load->view('pagamentopedidoview', $data);
        }

        function inserirclienteasaas(){
            $this->load->model('pagamentomodel', 'modelo');
            $usuario = $this->modelo->usuario($this->session->userdata('id'));
            $curl = curl_init();

            $configuracao = $this->modelo->configuracao();
			
			if($configuracao[0]->pagamento_producao){
				$ambiente = true; 
			}else{
				$ambiente = false; 
			}

			if($ambiente){

                //Ambiente de produção
                $wallet = $confIntegracao[0]->asaas_wallet; //Número de filiação da cielo. Em produção.
                $chave = $confIntegracao[0]->asaas_chave; // Chave de filiação da cielo. Em produção.

                //Ambiente de produção
                $url = 'https://api.asaas.com/';
				
			}else{
				
                //Ambiente de testes
                $wallet = '0b26c285-e542-43cd-8573-368e91a5ee74'; //Número de filiação da cielo. Em produção.
                $chave = '$aact_hmlg_000MzkwODA2MWY2OGM3MWRlMDU2NWM3MzJlNzZmNGZhZGY6OmUxMWE3M2U4LTMxMDEtNDE4ZS05YzY5LTdlZTA5MzJkYWQ0Yzo6JGFhY2hfMGZhMDAyNzYtZTg1Ny00Mjg1LWE1MzgtNmUzM2JlYTVkZDc5'; // Chave de filiação da cielo. Em produção.
                
                //Ambiente de testes
                $url = 'https://api-sandbox.asaas.com/';
                		                
			}

            $dados_post = [
                'name' => $usuario[0]->nome,
                'cpfCnpj' => $usuario[0]->cpf,
                'email' => $usuario[0]->email,
                'address' => $usuario[0]->endereco." - ".$usuario[0]->bairro,
                'addressNumber' => 0,
                'complement' => null,
                'province' => $usuario[0]->cidade,
                'postalCode' => $usuario[0]->cep,
                'externalReference' => $usuario[0]->id,
                'notificationDisabled' => false,
                'additionalEmails' => null,
                'municipalInscription' => null,
                'stateInscription' => null,
                'observations' => null,
                'groupName' => null,
                'company' => null,
                'foreignCustomer' => false
            ];
            if($usuario[0]->telcom){
                $dados_post['phone'] = $usuario[0]->telcom;
            }
            if($usuario[0]->telcel){
                $dados_post['mobilePhone'] = $usuario[0]->telcel;
            }
            
            curl_setopt_array($curl, [
              CURLOPT_URL => "https://sandbox.asaas.com/api/v3/customers",
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => "",
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => "POST",
              CURLOPT_POSTFIELDS => json_encode($dados_post),
              CURLOPT_HTTPHEADER => [
            	'accept: application/json',
            	'User-Agent: pagamentoasaas',
            	'access_token: '.$chave,
            	'content-type: application/json'
              ]
            ]);
            
            $response = curl_exec($curl);
            $err = curl_error($curl);
            
            curl_close($curl);
            
            if ($err) {
              //echo "cURL Error #:" . $err;
              $data['erro'] = "cURL Error #:" . $err;
            } else {
                //echo $response."<br><br>";
                $data['clienteid'] = substr($response,strpos($response,"id")+5,16);
                $data['cpf'] = substr($response,strpos($response,"cpfCnpj")+10,11);
            }
            return $data;
        }

        function pesquisarclienteasaas(){
            $this->load->model('pagamentomodel', 'modelo');
            $usuario = $this->modelo->usuario($this->session->userdata('id'));
            $cpf = str_replace(".","",str_replace("-","",str_replace("/","",$usuario[0]->cpf)));
            $data['clienteid'] = '';
            $data['cpf'] = '';
            $data['erro'] = '';

            $configuracao = $this->modelo->configuracao();
			
			if($configuracao[0]->pagamento_producao){
				$ambiente = true; 
			}else{
				$ambiente = false; 
			}

			if($ambiente){

                //Ambiente de produção
                $wallet = $confIntegracao[0]->asaas_wallet; //Número de filiação da cielo. Em produção.
                $chave = $confIntegracao[0]->asaas_chave; // Chave de filiação da cielo. Em produção.

                //Ambiente de produção
                $url = 'https://api.asaas.com/';
				
			}else{
				
                //Ambiente de testes
                $wallet = '0b26c285-e542-43cd-8573-368e91a5ee74'; //Número de filiação da cielo. Em produção.
                $chave = '$aact_hmlg_000MzkwODA2MWY2OGM3MWRlMDU2NWM3MzJlNzZmNGZhZGY6OmUxMWE3M2U4LTMxMDEtNDE4ZS05YzY5LTdlZTA5MzJkYWQ0Yzo6JGFhY2hfMGZhMDAyNzYtZTg1Ny00Mjg1LWE1MzgtNmUzM2JlYTVkZDc5'; // Chave de filiação da cielo. Em produção.
                
                //Ambiente de testes
                $url = 'https://api-sandbox.asaas.com/';
                		                
			}
            
            $curl = curl_init();
            curl_setopt_array($curl, [
              CURLOPT_URL => "https://api-sandbox.asaas.com/v3/customers?cpfCnpj=".$cpf,
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => "",
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => "GET",
              CURLOPT_HTTPHEADER => [
            	'accept: application/json',
            	'User-Agent: pagamentoasaas',
            	'access_token: '.$chave,
            	'content-type: application/json'
              ]
            ]);
            
            $response = curl_exec($curl);
            $err = curl_error($curl);
            
            curl_close($curl);
            
            if ($err) {
              echo "cURL Error #:" . $err;
              $data['erro'] = "cURL Error #:" . $err;
            } else {
                if(strpos($response,"id")){
                    //echo $response."<br><br>";
                    $data['clienteid'] = substr($response,strpos($response,"id")+5,16);
                    $data['cpf'] = substr($response,strpos($response,"cpfCnpj")+10,11);
                }
            }
            return $data;
        }


        function teste(){
            $this->load->model('pagamentomodel', 'modelo');
            $configuracao = $this->modelo->configuracao();
			
			if($configuracao[0]->pagamento_producao){
				$ambiente = true; 
			}else{
				$ambiente = false; 
			}

			if($ambiente){

                //Ambiente de produção
                $wallet = $confIntegracao[0]->asaas_wallet; 
                $chave = $confIntegracao[0]->asaas_chave; 

                //Ambiente de produção
                $url = 'https://api.asaas.com/';
				
			}else{
				
                //Ambiente de testes
                $wallet = '0b26c285-e542-43cd-8573-368e91a5ee74'; 
                $chave = '$aact_hmlg_000MzkwODA2MWY2OGM3MWRlMDU2NWM3MzJlNzZmNGZhZGY6OmUxMWE3M2U4LTMxMDEtNDE4ZS05YzY5LTdlZTA5MzJkYWQ0Yzo6JGFhY2hfMGZhMDAyNzYtZTg1Ny00Mjg1LWE1MzgtNmUzM2JlYTVkZDc5';
                
                //Ambiente de testes
                $url = 'https://api-sandbox.asaas.com/';
                		                
			}
			
            $dados_post = [
    		    'billingType' => 'CREDIT_CARD',
    		    'customer' => 'cus_000006407484',
    		    'value' => 129.9,
    		    'dueDate' => '2025-05-02',
    		    'description' => '056984',
    		    'externalReference' => '056984',
    		    'postalService' => false,
    		    'creditCard' => [
    			'holderName' => 'John Doe',
    			'number' => '1234567890123456',
    			'expiryMonth' => '5',
    			'expiryYear' => '2025',
    			'ccv' => '123'
    		    ],
    		    'authorizeOnly' => false
    		  ];
    		  
    		  //echo $dados_post;

    		$curl = curl_init();
    
    		curl_setopt_array($curl, [
    		  CURLOPT_URL => "https://sandbox.asaas.com/api/v3/payments/",
    		  CURLOPT_RETURNTRANSFER => true,
    		  CURLOPT_ENCODING => "",
    		  CURLOPT_MAXREDIRS => 10,
    		  CURLOPT_TIMEOUT => 30,
    		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    		  CURLOPT_CUSTOMREQUEST => "POST",
    		  CURLOPT_POSTFIELDS => json_encode($dados_post),
                  CURLOPT_HTTPHEADER => [
                	'accept: application/json',
                	'User-Agent: pagamentoasaas',
                	'access_token: '.$chave,
                	'content-type: application/json'
                  ]
    		]);
    
    		$response = curl_exec($curl);
    		$err = curl_error($curl);
    
    		curl_close($curl);
    
    		if ($err) {
    		  echo "cURL Error #:" . $err;
    		} else {
    		  echo $response;
    		}
        }

        function pixasaas(){

            $this->load->library('my_pix');
            $this->load->model('pagamentomodel', 'modelo');
            $token = md5(time());
            $data['token'] = $token;
            $this->session->set_userdata('token',$token);
			$produto = $this->modelo->produto($this->input->post('produto'));
			if(empty($produto[0]->usuariooff)){
				$this->my_acesso->logged();
			}
			$this->my_configuracao->confSess();
			$data['confIntegracao'] = $this->my_configuracao->confIntegracao();
            
            $semestoque = 0;
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            
            $item = $this->modelo->item($this->session->userdata('id'), $this->input->post('carrinho'));
            
            foreach ($item as $row) {
    
                $produto = $this->modelo->produto($row->produto);
                
                if($produto[0]->qtdade != '-1'){
                    if(($produto[0]->qtdade_saldo-$row->qtdade) < 0){
                        $semestoque = $row->produto;
                        $produtonome = $row->produtonome;
                    }
                    if($row->cupom && ($row->cupom_qtdade-$row->cupom_utilizado) < $row->qtdade){
                        $semestoquecupom = $row->produto;
                        $produtonome = $row->produtonome;
					}
                }
            }
            
            if(empty($semestoque)){
            	
	            if(empty($semestoquecupom)){
            	
		            $url_autenticacao = "url-autenticacao";
					$retorno['status'] = '';
					$retorno['url_autenticacao'] = '';
					$cliente = $this->pesquisarclienteasaas();
					if(empty($cliente['clienteid'])){
					    $cliente = $this->inserirclienteasaas();
					}
					$forma_pagamento = $this->modelo->pagamentoforma($this->input->post("pagamentoforma"));
	                $pagamentoTotal = $this->modelo->pagamentoTotal($this->session->userdata('id'), $this->input->post('carrinho')); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
	
					if($this->input->post('carrinho')){
						$id = $this->input->post('carrinho'); //ID a compra, geralmente alguma chave primária.
					}else{
						$id = $this->session->userdata('id'); //ID a compra, geralmente alguma chave primária.
					}
	                
                    $valor_total = number_format(floatval($pagamentoTotal[0]->total),2,'.','');
                    
                    $vencimento = date('Y-m-d'); //Data de vencimento
                    
                    $configuracao = $this->modelo->configuracao();
					
					if($configuracao[0]->pagamento_producao){
						$ambiente = true; 
					}else{
						$ambiente = false; 
					}
	
					if($ambiente){

		                //Ambiente de produção
		                $wallet = $confIntegracao[0]->asaas_wallet; //Número de filiação da cielo. Em produção.
		                $chave = $confIntegracao[0]->asaas_chave; // Chave de filiação da cielo. Em produção.

		                //Ambiente de produção
		                $url = 'https://api.asaas.com/v3/payments/';
						
					}else{
						
		                //Ambiente de testes
		                $wallet = '0b26c285-e542-43cd-8573-368e91a5ee74'; //Número de filiação da cielo. Em produção.
		                $chave = '$aact_hmlg_000MzkwODA2MWY2OGM3MWRlMDU2NWM3MzJlNzZmNGZhZGY6OmUxMWE3M2U4LTMxMDEtNDE4ZS05YzY5LTdlZTA5MzJkYWQ0Yzo6JGFhY2hfMGZhMDAyNzYtZTg1Ny00Mjg1LWE1MzgtNmUzM2JlYTVkZDc5'; // Chave de filiação da cielo. Em produção.
		                
		                //Ambiente de testes
		                $url = 'https://api-sandbox.asaas.com/v3/payments/';
		                		                
					}	

                    $dados_post = json_encode([
                        'billingType' => 'PIX',
                        'customer' => $cliente['clienteid'],
                        'value' => $pagamentoTotal[0]->total,
                        'dueDate' => $vencimento,
                        'description' => $produto[0]->titulo,
                        'externalReference' => $produto[0]->id,
                        'postalService' => false,
                        'authorizeOnly' => false
                    ]);

                    $curl = curl_init();
            
                    curl_setopt_array($curl, [
                        CURLOPT_URL => $url,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 30,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        CURLOPT_POSTFIELDS => $dados_post,
                        CURLOPT_HTTPHEADER => [
                            'accept: application/json',
                            'User-Agent: pagamentoasaas',
                            'access_token: '.$chave,
                            'content-type: application/json'
                        ]
            		]);
            
            		$response = curl_exec($curl);
            		$err = curl_error($curl);
            
            		curl_close($curl);
            
            		if ($err) {
            		  echo "cURL Error #:" . $err;
            		} else {
                        //echo $response."<br><br>";
                        
                        $tidarray = explode('"',substr($response,strpos($response,"id")));
                        $tid = $tidarray[2];
                        $statusarray = explode('"',substr($response,strpos($response,"status")));
                        $status = $statusarray[2];
            		  
                        $curl = curl_init();
                        curl_setopt_array($curl, [
                          CURLOPT_URL => "https://api-sandbox.asaas.com/v3/payments/$tid/pixQrCode",
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => "",
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 30,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => "GET",
                          CURLOPT_HTTPHEADER => [
                        	'accept: application/json',
                        	'User-Agent: pagamentoasaas',
                        	'access_token: '.$chave,
                        	'content-type: application/json'
                          ]
                        ]);
                        
                        $response2 = curl_exec($curl);
                        $err = curl_error($curl);
                        
                        curl_close($curl);
                        
                        if ($err) {
                          echo "cURL Error #:" . $err;
                          $data['erro'] = "cURL Error #:" . $err;
                        } else {
                            //echo $response2."<br><br>";
                            if(strpos($response2,"encodedImage")){
                                $pix['txid'] = $tid;
                                $payloadQrCodearray = explode('"',substr($response2,strpos($response2,"payload")));
                                $pix['payloadQrCode'] = $payloadQrCodearray[2];
                            }
                        }
            		}
    		
					if($pix['payloadQrCode']){
					    
					    $pedido = $this->modelo->addPedido($pix['txid'], $pagamentoTotal[0]->total, $forma_pagamento[0]->id, '9', $this->input->post('carrinho'));
					    
                        if($pedido){
                            $data['payloadQrCode'] = $pix['payloadQrCode'];
                            $data['qrcode'] = $this->my_pix->create_qrcode($pix['payloadQrCode']);
                            $data['mensagem'] = 'Após o pagamento do '.$produto[0]->titulo.' clique em "Processar pagamento".';
                        	$data['url'] = base_url()."minhascompras";
                			$data['pedido'] = $this->modelo->pedido($pix[txid]);
                			$data['pedidoitem'] = $this->modelo->pedidoitem($data['pedido'][0]->id);
                            $data['pagamentoTotal'] = $pagamentoTotal;
                            $data['pagamentoforma'] = $forma_pagamento;
                        }else{
                            $data['mensagem'] = "Houve um erro ao tentar gerar o Pix do produto \"$produtonome\". Por favor contactar o administrador do site.";
                        	$data['url'] = base_url()."produto/id/".$semestoquecupom;                
                        }
                    }else{
                        $retorno['mensagem'] = 'Erro ao tentar gerar Pix';
                        $retorno['resultado'] = false;
                    }
                }else{
                	$data['url'] = base_url()."produto/id/".$semestoquecupom;
                    $data['mensagem'] = "O produto \"$produtonome\" não tem cupons de desconto suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
                }
                
            } else {
            	$data['url'] = base_url()."produto/id/".$semestoque;
                $data['mensagem'] = "O produto \"$produtonome\" não tem estoque suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
            }
            //$data['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao." - Status nota: ".$pedidoresultado;
            //$data['mensagem'] .= $string;
            //echo json_encode($data);
            $this->load->view('pagamentopixview', $data);
        }

        function pixasaasautoriza(){
            $this->my_acesso->token();
            $this->load->model('pagamentomodel', 'modelo');
            $usuario = $this->modelo->usuario($this->session->userdata('id'));
            $pedido = $this->modelo->pedido($this->input->post('tid'));
            $tid = $this->input->post("tid");
            $configuracao = $this->modelo->configuracao();
			
			if($configuracao[0]->pagamento_producao){
				$ambiente = true; 
			}else{
				$ambiente = false; 
			}

			if($ambiente){

                //Ambiente de produção
                $wallet = $confIntegracao[0]->asaas_wallet; //Número de filiação da cielo. Em produção.
                $chave = $confIntegracao[0]->asaas_chave; // Chave de filiação da cielo. Em produção.

                //Ambiente de produção
                $url = 'https://api.asaas.com/';
				
			}else{
				
                //Ambiente de testes
                $wallet = '0b26c285-e542-43cd-8573-368e91a5ee74'; //Número de filiação da cielo. Em produção.
                $chave = '$aact_hmlg_000MzkwODA2MWY2OGM3MWRlMDU2NWM3MzJlNzZmNGZhZGY6OmUxMWE3M2U4LTMxMDEtNDE4ZS05YzY5LTdlZTA5MzJkYWQ0Yzo6JGFhY2hfMGZhMDAyNzYtZTg1Ny00Mjg1LWE1MzgtNmUzM2JlYTVkZDc5'; // Chave de filiação da cielo. Em produção.
                
                //Ambiente de testes
                $url = 'https://api-sandbox.asaas.com/';
                		                
			}
            
            $curl = curl_init();
            curl_setopt_array($curl, [
              CURLOPT_URL => "https://api-sandbox.asaas.com/v3/payments/".$tid,
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => "",
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => "GET",
              CURLOPT_HTTPHEADER => [
            	'accept: application/json',
            	'User-Agent: pagamentoasaas',
            	'access_token: '.$chave,
            	'content-type: application/json'
              ]
            ]);
            
            $response = curl_exec($curl);
            $err = curl_error($curl);
            
            curl_close($curl);
            
            if ($err) {
              echo "cURL Error #:" . $err;
              $data['erro'] = "cURL Error #:" . $err;
            } else {
                if(strpos($response,"status")){
                    //echo $response."<br><br>";
                    $statusarray = explode('"',substr($response,strpos($response,"status")));
                    $pix['status'] = $statusarray[2];
                }
            }

			
			//$data['pix'] = $pix;
			
			if($pix['status'] == 'RECEIVED'){
			    
			    $pixautoriza = $this->modelo->pixautoriza('1', $pedido);
			    
                if($pixautoriza){
                    $data['mensagem'] = 'Pagamento confirmado.';
                    $data['resultado'] = true;
                }else{
                    $data['mensagem'] = "O pagamento foi confirmado, mas houve erro ao gerar o pedido. Contate o administrador do site.";
                	$data['url'] = base_url()."produto/id/".$semestoquecupom;                
                }
            }elseif($pix['status'] == 'PENDING'){
                $data['mensagem'] = 'Pagamento pendente.';
                $data['resultado'] = false;
            }else{
                $data['mensagem'] = 'Pagamento não efetuado';
                $data['resultado'] = false;
            }
            
            //$data['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao." - Status nota: ".$pedidoresultado;
            //$data['mensagem'] .= $string;
            echo json_encode($data);
        }

        function pedidoasaas(){

			if(empty($produto[0]->usuariooff)){
				$this->my_acesso->logged();
			}
            $this->my_acesso->token();
			$this->my_configuracao->confSess();                       
            $this->load->model('pagamentomodel', 'modelo');
            $confIntegracao = $this->my_configuracao->confIntegracao();
			$produto = $this->modelo->produto($this->input->post('produto'));

            $semestoque = 0;
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            
            $item = $this->modelo->item($this->session->userdata('id'), $this->input->post('carrinho'));
            
            foreach ($item as $row) {
    
                $produto = $this->modelo->produto($row->produto);
                
                if($produto[0]->qtdade != '-1'){
                    if(($produto[0]->qtdade_saldo-$row->qtdade) < 0){
                        $semestoque = $row->produto;
                        $produtonome = $row->produtonome;
                    }
                    if($row->cupom && ($row->cupom_qtdade-$row->cupom_utilizado) < $row->qtdade){
                        $semestoquecupom = $row->produto;
                        $produtonome = $row->produtonome;
                    }
                }
            }
            
            if(empty($semestoque)){
            	
	            if(empty($semestoquecupom)){
            	
		            $url_autenticacao = "url-autenticacao";
					$retorno['status'] = '';
					$retorno['url_autenticacao'] = '';
					$cliente = $this->pesquisarclienteasaas();
					if(empty($cliente['clienteid'])){
					    $cliente = $this->inserirclienteasaas();
					}
					$forma_pagamento = $this->modelo->pagamentoforma($this->input->post("pagamentoforma"));
	                $pagamentoTotal = $this->modelo->pagamentoTotal($this->session->userdata('id'), $this->input->post('carrinho')); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
	
					if($this->input->post('carrinho')){
						$id = $this->input->post('carrinho'); //ID a compra, geralmente alguma chave primária.
					}else{
						$id = $this->session->userdata('id'); //ID a compra, geralmente alguma chave primária.
					}
	                
	                $valor_total = number_format(floatval($pagamentoTotal[0]->total),2,'.','');
	
	                $bandeira = $this->input->post("bandeira"); //Bandeira, no caso a Visa, outras bandeiras olhar no manual
	
	                $vencimento = date('Y-m-d'); //Data de vencimento
	
	                $nome_titular = $this->input->post("nome_titular"); //Nome do dono do cartão exatamente como impresso no mesmo.
	
	                $numero_cartao = $this->input->post("numero_cartao"); //Número do cartão de crédito, apenas números.
	
	                $codigo_cartao = $this->input->post("codigo_cartao"); //Código de segurança do verso do cartão
	
	                $validademes = substr($this->input->post("data_vencimento"), 0, 2); //Mês com dois dígitos de vencimento do cartão, no exemplo maio de 2018.

	                $validadeano = "20".substr($this->input->post("data_vencimento"), 3, 2); //Ano com 4 dígitos e Mês com dois dígitos de vencimento do cartão, no exemplo maio de 2018.
	
	                $captura = 'true'; //A captura é quando após aprovada a transação você confirma para a operadora que quer o dinheiro, observe que se você não capturar, mesmo uma transação autorizada, não gerará débito para o usuário. No caso estou dizendo que se a transação for autorizada ela deve ser capturada, caso queira fazer a captura posteriormente devo usar false no lugar e posteriormente realizar a captura em outro procedimento.
	                
	                $configuracao = $this->modelo->configuracao();
					
					if($configuracao[0]->pagamento_producao){
						$ambiente = true; 
					}else{
						$ambiente = false; 
					}
	
					if($ambiente){

		                //Ambiente de produção
		                $wallet = $confIntegracao[0]->asaas_wallet; //Número de filiação da cielo. Em produção.
		                $chave = $confIntegracao[0]->asaas_chave; // Chave de filiação da cielo. Em produção.

		                //Ambiente de produção
		                $url = 'https://api.asaas.com/v3/payments/';
						
					}else{
						
		                //Ambiente de testes
		                $wallet = '0b26c285-e542-43cd-8573-368e91a5ee74'; //Número de filiação da cielo. Em produção.
		                $chave = '$aact_hmlg_000MzkwODA2MWY2OGM3MWRlMDU2NWM3MzJlNzZmNGZhZGY6OmUxMWE3M2U4LTMxMDEtNDE4ZS05YzY5LTdlZTA5MzJkYWQ0Yzo6JGFhY2hfMGZhMDAyNzYtZTg1Ny00Mjg1LWE1MzgtNmUzM2JlYTVkZDc5'; // Chave de filiação da cielo. Em produção.
		                
		                //Ambiente de testes
		                $url = 'https://api-sandbox.asaas.com/v3/payments/';
		                		                
					}	

                    if($forma_pagamento[0]->tipo === 'C'){
                        $dados_post = json_encode([
                            'billingType' => 'CREDIT_CARD',
                            'customer' => $cliente['clienteid'],
                            'value' => $pagamentoTotal[0]->total,
                            'dueDate' => $vencimento,
                            'description' => $produto[0]->titulo,
                            'externalReference' => $produto[0]->id,
                            'installmentCount' => $forma_pagamento[0]->qtde_parcelas,
                            'totalValue' => $pagamentoTotal[0]->total,
                            'postalService' => false,
                            'creditCard' => [
                            'holderName' => $nome_titular,
                            'number' => $numero_cartao,
                            'expiryMonth' => $validademes,
                            'expiryYear' => $validadeano,
                            'ccv' => $codigo_cartao
                            ],
                            'authorizeOnly' => false
                        ]);
	                } else {
                        $dados_post = json_encode([
                            'billingType' => 'CREDIT_CARD',
                            'customer' => $cliente['clienteid'],
                            'value' => $pagamentoTotal[0]->total,
                            'dueDate' => $vencimento,
                            'description' => $produto[0]->titulo,
                            'externalReference' => $produto[0]->id,
                            'postalService' => false,
                            'creditCard' => [
                            'holderName' => $nome_titular,
                            'number' => $numero_cartao,
                            'expiryMonth' => $validademes,
                            'expiryYear' => $validadeano,
                            'ccv' => $codigo_cartao
                            ],
                            'authorizeOnly' => false
                        ]);
	                }

                    $curl = curl_init();
            
                    curl_setopt_array($curl, [
                        CURLOPT_URL => $url,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 30,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        CURLOPT_POSTFIELDS => $dados_post,
                        CURLOPT_HTTPHEADER => [
                            'accept: application/json',
                            'User-Agent: pagamentoasaas',
                            'access_token: '.$chave,
                            'content-type: application/json'
                        ]
            		]);
            
            		$response = curl_exec($curl);
            		$err = curl_error($curl);
            
            		curl_close($curl);
            
            		if ($err) {
            		  echo "cURL Error #:" . $err;
            		} else {
            		  //echo $response."<br><br>";
            		  $tidarray = explode('"',substr($response,strpos($response,"id")));
            		  $tid = $tidarray[2];
            		  //echo $tid."<br><br>";
            		  $statusarray = explode('"',substr($response,strpos($response,"status")));
            		  $status = $statusarray[2];
            		  //echo $status."<br><br>";
            		}
    		
                    if ($tid){
                        
                        if($status == 'CONFIRMED'){
                            /*echo "Tid: ".$tid."<br><br>";
                            echo "Valor: ".$valor_total."<br><br>";
                            echo "Foma de pagamento: ".$forma_pagamento[0]->id."<br><br>";
                            echo "Carrinho: ".$this->input->post('carrinho')."<br><br>";*/
                            
                        	$pedidoresultado = $this->modelo->addPedido($tid, $valor_total, $forma_pagamento[0]->id, '1', $this->input->post('carrinho'));
                        	if($pedidoresultado){
                            	$retorno['status'] = $status."";
                                $retorno['mensagem'] = 'Transação autorizada pela operadora do cartão.';
								if(!$this->session->userdata('id') && $this->input->post('carrinho')){
									$pedido = $this->modelo->pedido($tid."");
									//redirect(base_url()."ticket/pdf/".$pedido[0]->id);
									$retorno['pedido'] = $pedido[0]->id;
								}
                                $retorno['resultado'] = true;
                            }else{
                                $retorno['mensagem'] = 'Transação autorizada pela operadora do cartão. Mas houve um erro ao tentar gerar o pedido, por favor contato o administrador do sistema.';
                                $retorno['resultado'] = false;
                            }
                        }elseif($xml->$url_autenticacao && $status == '0'){
                        	if($this->modelo->insereTid($tid, $this->session->userdata('id'), $this->input->post('carrinho'))){
	                        	$retorno['status'] = $status."";
								$retorno['url_autenticacao'] = "".$xml->$url_autenticacao;
	                            $retorno['mensagem'] = 'Transação processada com sucesso pela loja '.$this->session->userdata('nome_projeto').'.<br/>Por favor, conclua o procedimento de pagamento junto ao seu banco para conclusão da compra.';
	                            $retorno['resultado'] = true;
                            }else{
                                $retorno['mensagem'] = 'Houve um erro na transação. A transação não foi processada. Nos ajude a resolver esse problema enviando-nos um contato. Obrigado.';
                                $retorno['resultado'] = false;
                        	}
                        }else{
                            $retorno['mensagem'] = 'Transação não autorizada: '.$xml->autorizacao->mensagem.'.';
                            $retorno['resultado'] = false;
                        }       
                    }else{
                        $retorno['mensagem'] = 'Transação não autorizada: '.$xml->mensagem;
                        $retorno['resultado'] = false;
                    }
	            }else{
	            	$retorno['url_autenticacao'] = base_url()."produto/id/".$semestoquecupom;
	                $retorno['mensagem'] = "O produto \"$produtonome\" não tem cupons de desconto suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
	                $retorno['resultado'] = false;
	            }
                
            }else{
            	$retorno['url_autenticacao'] = base_url()."produto/id/".$semestoque;
                $retorno['mensagem'] = "O produto \"$produtonome\" não tem estoque suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
                $retorno['resultado'] = false;
            }
            //$retorno['mensagem'] .= " - Status: ".$status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$tid." - URL autenticação: ".$xml->$url_autenticacao." - Status nota: ".$pedidoresultado;
            //$retorno['mensagem'] .= $string;
            echo json_encode($retorno);
    		
        }


        function pedido(){
            
			if(empty($produto[0]->usuariooff)){
				$this->my_acesso->logged();
			}
            $this->my_acesso->token(); 
			$this->my_configuracao->confSess();                       
            $this->load->model('pagamentomodel', 'modelo');
			$produto = $this->modelo->produto($this->input->post('produto'));

            $semestoque = 0;
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            
            $item = $this->modelo->item($this->session->userdata('id'), $this->input->post('carrinho'));
            
            foreach ($item as $row) {
    
                $produto = $this->modelo->produto($row->produto);
                
                if($produto[0]->qtdade != '-1'){
                    if(($produto[0]->qtdade_saldo-$row->qtdade) < 0){
                        $semestoque = $row->produto;
                        $produtonome = $row->produtonome;
                    }
                    if($row->cupom && ($row->cupom_qtdade-$row->cupom_utilizado) < $row->qtdade){
                        $semestoquecupom = $row->produto;
                        $produtonome = $row->produtonome;
                    }
                }
            }
            
            if(empty($semestoque)){
            	
	            if(empty($semestoquecupom)){
            	
		            $url_autenticacao = "url-autenticacao";
					$retorno['status'] = '';
					$retorno['url_autenticacao'] = '';
					$forma_pagamento = $this->modelo->pagamentoforma($this->input->post("pagamentoforma"));
	                $pagamentoTotal = $this->modelo->pagamentoTotal($this->session->userdata('id'), $this->input->post('carrinho')); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
	
					if($this->input->post('carrinho')){
						$id = $this->input->post('carrinho'); //ID a compra, geralmente alguma chave primária.
					}else{
						$id = $this->session->userdata('id'); //ID a compra, geralmente alguma chave primária.
					}
	                
	                $valor_total = number_format(floatval($pagamentoTotal[0]->total),2,'.','');
	
	                $valorsemponto = str_replace(",", "",str_replace(".", "", $valor_total)); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
	
	                $bandeira = $this->input->post("bandeira"); //Bandeira, no caso a Visa, outras bandeiras olhar no manual
	
	                $agora = date('Y-m-d\TH:i:s'); //Data atual
	
	                $nome_titular = $this->input->post("nome_titular"); //Nome do dono do cartão exatamente como impresso no mesmo.
	
	                $numero_cartao = $this->input->post("numero_cartao"); //Número do cartão de crédito, apenas números.
	
	                $codigo_cartao = $this->input->post("codigo_cartao"); //Código de segurança do verso do cartão
	
	                $indicador = ($codigo_cartao != '')?'1':'0'; //Se o cartão não tiver código de segurança o indicaro é zero, caso contrário um
	
	                $data_vencimento = "20".substr($this->input->post("data_vencimento"), 3, 2).substr($this->input->post("data_vencimento"), 0, 2); //Ano com 4 dígitos e Mês com dois dígitos de vencimento do cartão, no exemplo maio de 2018.
	
	                if($forma_pagamento[0]->tipo === 'D'){
	                	$qtd_parcelas = '1'; //Quantidade total de parcelas
		                $produto = 'A'; //Sempre que a quantidade de parcelas for igual a 1 o produto deve ser 1, caso contrário ele deve ser 2 ou 3 (ver o manual) ou A para débito.
		                $autorizar = '1'; //No caso a '3' é a chamada "autorização direta", para entender o que é e quais as outras opções consulte o manual
		                $url_retorno = base_url().'pagamento/autoriza/';
						$this->session->set_userdata("fpagamento", $forma_pagamento[0]->id);
						$this->session->set_userdata("carrinho", $this->input->post('carrinho'));
					}elseif($forma_pagamento[0]->tipo === 'V'){
	                	$qtd_parcelas = '1'; //Quantidade total de parcelas
		                $produto = '1'; //Sempre que a quantidade de parcelas for igual a 1 o produto deve ser 1, caso contrário ele deve ser 2 ou 3 (ver o manual)
		                $autorizar = '3'; //No caso a '3' é a chamada "autorização direta", para entender o que é e quais as outras opções consulte o manual
		                $url_retorno = 'null';
	                }elseif($forma_pagamento[0]->tipo === 'C'){
		                $qtd_parcelas = $forma_pagamento[0]->qtde_parcelas; //Quantidade total de parcelas
		                $produto = '2'; //Sempre que a quantidade de parcelas for igual a 1 o produto deve ser 1, caso contrário ele deve ser 2 ou 3 (ver o manual)
		                $autorizar = '3'; //No caso a '3' é a chamada "autorização direta", para entender o que é e quais as outras opções consulte o manual
		                $url_retorno = 'null';
	                }
	
	                $captura = 'true'; //A captura é quando após aprovada a transação você confirma para a operadora que quer o dinheiro, observe que se você não capturar, mesmo uma transação autorizada, não gerará débito para o usuário. No caso estou dizendo que se a transação for autorizada ela deve ser capturada, caso queira fazer a captura posteriormente devo usar false no lugar e posteriormente realizar a captura em outro procedimento.
	                
	                $configuracao = $this->modelo->configuracao();
					
					if($configuracao[0]->pagamento_producao){
						$ambiente = true; 
					}else{
						$ambiente = false; 
					}
	
					if($ambiente){
						if($item[0]->unidade){
			                //Ambiente de produção
			                $cielo_numero = $item[0]->cielo_numero; //Número de filiação da cielo. Em produção.
			                $chave_cielo = $item[0]->cielo_chave; // Chave de filiação da cielo. Em produção.
						}else{
			                //Ambiente de produção
			                $cielo_numero = $configuracao[0]->cielo_numero; //Número de filiação da cielo. Em produção.
			                $chave_cielo = $configuracao[0]->cielo_chave; // Chave de filiação da cielo. Em produção.
						}

		                //Ambiente de produção
		                $url = 'https://ecommerce.cielo.com.br/servicos/ecommwsec.do';
						
					}else{
						
		                //Ambiente de testes
		                $cielo_numero = '1006993069'; //Número de filiação da cielo, neste caso é o exemplo da homologação
		                $chave_cielo = '25fbb99741c739dd84d7b06ec78c9bac718838630f30b112d033ce2e621b34f3'; // Chave de filiação da cielo, neste caso é o exemplo da homologação
		                
		                //Ambiente de testes
		                $url = 'https://qasecommerce.cielo.com.br/servicos/ecommwsec.do';
		                		                
					}	

	                $string = "<?xml version='1.0' encoding='ISO-8859-1'?>
	                <requisicao-transacao id='a97ab62a-7956-41ea-b03f-c2e9f612c293' versao='1.2.1'>
	                    <dados-ec>
	                          <numero>$cielo_numero</numero>
	                          <chave>$chave_cielo</chave>
	                    </dados-ec>
	                    <dados-portador>
	                        <numero>$numero_cartao</numero>
	                        <validade>$data_vencimento</validade>
	                        <indicador>$indicador</indicador>
	                        <codigo-seguranca>$codigo_cartao</codigo-seguranca>
	                        <nome-portador>$nome_titular</nome-portador>
	                    </dados-portador>
	                    <dados-pedido>
	                        <numero>$id</numero>
	                        <valor>$valorsemponto</valor>
	                        <moeda>986</moeda>
	                        <data-hora>$agora</data-hora>
	                        <descricao><!--[CDATA[{www.eliaspa.com.br]]--></descricao>
	                        <idioma>PT</idioma>
	                    </dados-pedido>
	                    <forma-pagamento>
	                        <bandeira>$bandeira</bandeira>
	                        <produto>$produto</produto>
	                        <parcelas>$qtd_parcelas</parcelas>
	                    </forma-pagamento>
	                    <url-retorno>$url_retorno</url-retorno>
	                    <autorizar>$autorizar</autorizar>
	                    <capturar>$captura</capturar>
	                </requisicao-transacao>";
	                //exit($string);
	
                    $ch = curl_init();
                    flush();
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS,  'mensagem=' . $string);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_URL, $url);
                    //curl_setopt($ch, CURLOPT_SSLVERSION, 4);
                    //curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_FAILONERROR, true);
                    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 40);
                    $resultado = curl_exec($ch);
                    curl_close($ch);

                    $xml = simplexml_load_string($resultado);

                    if ($xml->tid or true){
                        //$retorno['mensagem'] .= 'TID da transação: '.$xml->tid.'<br>';
                        if($xml->status == '6' or true){
                        	$pedidoresultado = $this->modelo->addPedido($xml->tid, $valor_total, $forma_pagamento[0]->id, '1', $this->input->post('carrinho'));
                        	if($pedidoresultado){
                            	$retorno['status'] = $xml->status."";
                                $retorno['mensagem'] = 'Transação autorizada pela operadora do cartão.';
								if(!$this->session->userdata('id') && $this->input->post('carrinho')){
									$pedido = $this->modelo->pedido($xml->tid."");
									//redirect(base_url()."ticket/pdf/".$pedido[0]->id);
									$retorno['pedido'] = $pedido[0]->id;
								}
                                $retorno['resultado'] = true;
                            }else{
                                $retorno['mensagem'] = 'Transação autorizada pela operadora do cartão. Mas houve um erro ao tentar gerar o pedido, por favor contato o administrador do sistema.';
                                $retorno['resultado'] = false;
                            }
                        }elseif($xml->$url_autenticacao && $xml->status == '0'){
                        	if($this->modelo->insereTid($xml->tid, $this->session->userdata('id'), $this->input->post('carrinho'))){
	                        	$retorno['status'] = $xml->status."";
								$retorno['url_autenticacao'] = "".$xml->$url_autenticacao;
	                            $retorno['mensagem'] = 'Transação processada com sucesso pela loja '.$this->session->userdata('nome_projeto').'.<br/>Por favor, conclua o procedimento de pagamento junto ao seu banco para conclusão da compra.';
	                            $retorno['resultado'] = true;
                            }else{
                                $retorno['mensagem'] = 'Houve um erro na transação. A transação não foi processada. Nos ajude a resolver esse problema enviando-nos um contato. Obrigado.';
                                $retorno['resultado'] = false;
                        	}
                        }else{
                            $retorno['mensagem'] = 'Transação não autorizada: '.$xml->autorizacao->mensagem.'.';
                            $retorno['resultado'] = false;
                        }       
                    }else{
                        $retorno['mensagem'] = 'Transação não autorizada: '.$xml->mensagem;
                        $retorno['resultado'] = false;
                    }
	            }else{
	            	$retorno['url_autenticacao'] = base_url()."produto/id/".$semestoquecupom;
	                $retorno['mensagem'] = "O produto \"$produtonome\" não tem cupons de desconto suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
	                $retorno['resultado'] = false;
	            }
                
            }else{
            	$retorno['url_autenticacao'] = base_url()."produto/id/".$semestoque;
                $retorno['mensagem'] = "O produto \"$produtonome\" não tem estoque suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
                $retorno['resultado'] = false;
            }
            $retorno['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao." - Status nota: ".$pedidoresultado;
            $retorno['mensagem'] .= $string;
            echo json_encode($retorno);
        }
        
        function autoriza(){

            ini_set('error_reporting', E_STRICT);
			
			$semestoque = 0;
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            $this->load->model('pagamentomodel', 'modelo');

			$item = $this->modelo->item($this->session->userdata('id'),$this->session->userdata('carrinho'));
			$tid = $item[0]->tid;
			
			if($tid){
	
	            $pagamentoTotal = $this->modelo->pagamentoTotal($this->session->userdata('id'), $this->session->userdata('carrinho')); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
				$forma_pagamento = $this->modelo->pagamentoforma($this->session->userdata('fpagamento'));
				
	            $valor_total = number_format(floatval($pagamentoTotal[0]->total),2,'.','');

                $valorsemponto = str_replace(",", "",str_replace(".", "", $valor_total)); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
			    
                $configuracao = $this->modelo->configuracao();
				
				if($configuracao[0]->pagamento_producao){
					$ambiente = true; 
				}else{
					$ambiente = false; 
				}

				if($ambiente){
					
					if($item[0]->unidade){
		                //Ambiente de produção
		                $cielo_numero = $item[0]->cielo_numero; //Número de filiação da cielo. Em produção.
		                $chave_cielo = $item[0]->cielo_chave; // Chave de filiação da cielo. Em produção.
					}else{
		                //Ambiente de produção
		                $cielo_numero = $configuracao[0]->cielo_numero; //Número de filiação da cielo. Em produção.
		                $chave_cielo = $configuracao[0]->cielo_chave; // Chave de filiação da cielo. Em produção.
					}
	
	                //Ambiente de produção
	                $url = 'https://ecommerce.cielo.com.br/servicos/ecommwsec.do';
					
				}else{
					
	                //Ambiente de testes
	                $cielo_numero = '1006993069'; //Número de filiação da cielo, neste caso é o exemplo da homologação
	                $chave_cielo = '25fbb99741c739dd84d7b06ec78c9bac718838630f30b112d033ce2e621b34f3'; // Chave de filiação da cielo, neste caso é o exemplo da homologação
	                
	                //Ambiente de testes
	                $url = 'https://qasecommerce.cielo.com.br/servicos/ecommwsec.do';
	                		                
				}	
	            
                $string = "<?xml version='1.0' encoding='ISO-8859-1'?> 
                <requisicao-consulta id='6fcf758e-bc60-4d6a-acf4-496593a40441' versao='1.2.1'> 
                	<tid>$tid</tid> 
                	<dados-ec> 
                          <numero>$cielo_numero</numero>
                          <chave>$chave_cielo</chave>
                	</dados-ec> 
            	</requisicao-consulta>";
                //exit($string);
                
                    $ch = curl_init();
                    flush();
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS,  'mensagem=' . $string);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_URL, $url);
                    //curl_setopt($ch, CURLOPT_SSLVERSION, 4);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_FAILONERROR, true);
                    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 40);
                    $resultado = curl_exec($ch);
                    curl_close($ch);
                    $xml = simplexml_load_string($resultado);

                    //$retorno['mensagem'] .= 'TID da transação: '.$xml->tid.'<br>';
		    		//exit($xml->status);
                                            
                    if($xml->status == '6'){
                    	
                        if($this->modelo->addPedido($xml->tid, $valor_total, $forma_pagamento[0]->id, '1', $this->session->userdata('carrinho'))){
                            $data['mensagem'] = 'Transação autorizada pela operadora.';
							$data['mensagemredirect'] = "Você está sendo redirecionado para suas compras em ";
							$data['url'] = base_url()."minhascompras";
                            $data['resultado'] = true;
                        }else{
                            $data['mensagem'] = 'O pagamento foi processado com sucesso. Mas houve um erro ao tentar gerar o pedido, por favor contato o administrador do sistema.';
							$data['mensagemredirect'] = "Você está sendo redirecionado para suas compras em ";
							$data['url'] = base_url()."minhascompras";
                            $data['resultado'] = true;
                        }
                    }else{
						/*$data['mensagem'] = "Desculpe, mas não foi possível concluir a compra. Algum dos motivos abaixo podem ter ocorrido:<br/><br/>
						
						1. Site do banco não localizado;<br/>
						2. Erro nos dados do cartão;<br/>
						3. Cancelamento manual do pagamento;<br/>
						4. Lentidão na conexão de internet;<br/>
						5. Saldo indisponível.<br/><br/>";*/

                        $data['mensagem'] = "Transação não autorizada.<br/>";
                        $data['resultado'] = false;
						$data['url'] = base_url()."carrinho";
						$data['mensagemredirect'] = "Por favor, verifique os dados do cartão ou tente novamente.<br/>Você será redirecionado para o carrinho de compras em ";
                    }       
				
			}else{
                $data['mensagem'] = "Não existem processamentos de compras. Obrigado.";                
                $data['resultado'] = false;
				$data['url'] = base_url()."carrinho";
				$data['mensagemredirect'] = "Por favor, verifique os dados do cartão ou tente novamente.<br/>Você será redirecionado para o seu carrinho de compras em ";
			}
            //$data['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao;
            //$data['mensagem'] .= $stringcancela;
            //$data['mensagem'] .= " - Status: ".$xmlcancela->status;
            $data['menu_id'] = '15';
            $this->load->view('pagamentoresultadoview', $data);
        }

        function pedidogratis($carrinho){

            $this->load->model('pagamentomodel', 'modelo');
            $item = $this->modelo->item($this->session->userdata('id'), $carrinho);
			$produto = $this->modelo->produto($item[0]->produto);
			if(empty($produto[0]->usuariooff)){
				$this->my_acesso->logged();
			}
			$this->my_configuracao->confSess();                       
            
            $semestoque = 0;
            $data['mensagem'] = "";
            $data['resultado'] = false;
   
            
            foreach ($item as $row) {
    
                $produto = $this->modelo->produto($row->produto);

                if($produto[0]->qtdade != '-1'){
	                if(($produto[0]->qtdade_saldo-$row->qtdade) < 0){
	                    $semestoque = $row->produto;
	                    $produtonome = $row->produtonome;
	                }
	            	if($row->cupom && ($row->cupom_qtdade-$row->cupom_utilizado) < $row->qtdade){
	                    $semestoquecupom = $row->produto;
	                    $produtonome = $row->produtonome;
					}
                }
            }

            if(empty($semestoque)){
	            if(empty($semestoquecupom)){
	            	if($this->modelo->addPedido("", 0, '99', '1', $carrinho)){
		                $data['mensagem'] = "O produto ".$produto[0]->titulo." foi adquirido com sucesso.<br />Você receberá um e-mail com as instruções.<br /> Você está sendo redirecionado para os seus pedidos em <span class='count'>10</span> segundos.";
						$data['url'] = base_url()."minhascompras";
					}else{
		                $data['mensagem'] = "Houve um erro ao tentar adquirir o produto \"$produtonome\". Por favor contactar o administrador do site.";
						$data['url'] = base_url()."produto/id/".$semestoquecupom;                
					}
					
	            }else{
	            	$data['url'] = base_url()."produto/id/".$semestoquecupom;
	                $data['mensagem'] = "O produto \"$produtonome\" não tem cupons de desconto suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
	            }
                
            } else {
            	$data['url'] = base_url()."produto/id/".$semestoque;
                $data['mensagem'] = "O produto \"$produtonome\" não tem estoque suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
            }
            //$data['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao." - Status nota: ".$pedidoresultado;
            //$data['mensagem'] .= $string;
            //echo json_encode($data);
            $this->load->view('pagamentogratisview', $data);
		}

        function pixestatico(){
            $this->load->library('my_pix');
            $this->load->model('pagamentomodel', 'modelo');
            $token = md5(time());
            $data['token'] = $token;
            $this->session->set_userdata('token',$token);
			$produto = $this->modelo->produto($this->input->post('produto'));
			if(empty($produto[0]->usuariooff)){
				$this->my_acesso->logged();
			}
			$this->my_configuracao->confSess();                      
            
            $semestoque = 0;
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            
            $item = $this->modelo->item($this->session->userdata('id'), $this->input->post('carrinho'));
            
            foreach ($item as $row) {
    
                $produto = $this->modelo->produto($row->produto);
                
                if($produto[0]->qtdade != '-1'){
                    if(($produto[0]->qtdade_saldo-$row->qtdade) < 0){
                        $semestoque = $row->produto;
                        $produtonome = $row->produtonome;
                    }
                    if($row->cupom && ($row->cupom_qtdade-$row->cupom_utilizado) < $row->qtdade){
                        $semestoquecupom = $row->produto;
                        $produtonome = $row->produtonome;
					}
                }
            }
            
            if(empty($semestoque)){
            	
	            if(empty($semestoquecupom)){
	                $configuracao = $this->modelo->configuracao();
            	
		            $url_autenticacao = "url-autenticacao";
					$retorno['status'] = '';
					$retorno['url_autenticacao'] = '';
					$forma_pagamento = $this->modelo->pagamentoforma($this->input->post("pagamentoforma"));
	                $pagamentoTotal = $this->modelo->pagamentoTotal($this->session->userdata('id'), $this->input->post('carrinho')); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
	
					if($this->input->post('carrinho')){
						$id = $this->input->post('carrinho'); //ID da compra, geralmente alguma chave primária.
					}else{
						$id = $this->session->userdata('id'); //ID da compra, geralmente alguma chave primária.
					}
                    
                    $valor = $pagamentoTotal[0]->total;
                    $txid = "MEDPLAY".sprintf("%011d", $item[0]->id);

					if($configuracao[0]->pagamento_producao){
                        
                        //Ambiente de produção
                        $url = $configuracao[0]->pix_url;
                        $client_id = $configuracao[0]->pix_client_id; //Cliente ID do Pix. Em produção.
                        $client_secret = $configuracao[0]->pix_client_secret; //Cliente secret do Pix. Em produção.
                        if(stristr(__FILE__, 'desenvolvimento')) {
                            $certificado = $_SERVER['DOCUMENT_ROOT'].'/desenvolvimento/site/iportal/public/biblioteca-de-arquivos/unidade/'.$configuracao[0]->pix_certificado; //Certificado do Pix em produção.
                        } else {
                            $certificado = $_SERVER['DOCUMENT_ROOT'].'/site/iportal/public/biblioteca-de-arquivos/unidade/'.$configuracao[0]->pix_certificado; //Certificado do Pix em produção.
                        }
                        $chave = $configuracao[0]->pix_chave;
                        $nome = $configuracao[0]->pix_nome;
                        $cidade = $configuracao[0]->pix_cidade;
						
					}else{
						
                        //Ambiente de homologação
                        $url = 'https://api-pix-h.gerencianet.com.br';
                        $client_id = 'Client_Id_8ef12d5c598ca7e93c171e4be338cd7e2035fb13'; //Cliente ID do Pix. Em produção.
                        $client_secret = 'Client_Secret_5f94e449d3fe4d219554477437c16514e86e3678'; //Cliente secret do Pix. Em produção.
                        if(stristr(__FILE__, 'desenvolvimento')) {
                            $certificado = $_SERVER['DOCUMENT_ROOT'].'/desenvolvimento/site/application/libraries/pix/files/certificates/certificadopix.pem'; //Certificado do Pix em produção.
                        } else {
                            $certificado = $_SERVER['DOCUMENT_ROOT'].'/site/application/libraries/pix/files/certificates/certificadopix.pem'; //Certificado do Pix em produção.
                        }
                        $chave = '12345678909';
                        $nome = 'Michaell Stroid Lima e Silva';
                        $cidade = 'São Francisco do Sul';
                    	                
					}

					$pix = $this->my_pix->create_pix_estatico($valor, $chave, $produto[0]->titulo, $nome, $cidade, $txid);
					/*
					echo "<pre>";
					echo $url."<br/>";
					echo $client_id."<br/>";
					echo $client_secret."<br/>";
					echo $certificado."<br/>";
					echo $valor."<br/>";
					echo $chave."<br/>";
					echo $produto[0]->titulo."<br/>";
					echo $nome."<br/>";
					echo $cidade."<br/>";
					echo $item[0]->id."<br/>";
					
					print_r($pix);
					*/
					
					if($pix['payloadQrCode']){
					    
					    $pedido = $this->modelo->addPedido($txid, $valor, $forma_pagamento[0]->id, '9', $this->input->post('carrinho'));
					    
                        if($pedido){
                            $data['payloadQrCode'] = $pix['payloadQrCode'];
                            $data['qrcode'] = $this->my_pix->create_qrcode($pix['payloadQrCode']);
                            $data['mensagem'] = 'Após o pagamento do '.$produto[0]->titulo.' clique em "Processar pagamento".';
                        	$data['url'] = base_url()."minhascompras";
                			$data['pedido'] = $this->modelo->pedido($txid);
                			$data['pedidoitem'] = $this->modelo->pedidoitem($data['pedido'][0]->id);
                            $data['pagamentoTotal'] = $pagamentoTotal;
                            $data['pagamentoforma'] = $forma_pagamento;
                        }else{
                            $data['mensagem'] = "Houve um erro ao tentar gerar o Pix o produto \"$produtonome\". Por favor contactar o administrador do site.";
                        	$data['url'] = base_url()."produto/id/".$semestoquecupom;                
                        }
                    }else{
                        $retorno['mensagem'] = 'Erro ao tentar gerar Pix';
                        $retorno['resultado'] = false;
                    }
                }else{
                	$data['url'] = base_url()."produto/id/".$semestoquecupom;
                    $data['mensagem'] = "O produto \"$produtonome\" não tem cupons de desconto suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
                }
                
            } else {
            	$data['url'] = base_url()."produto/id/".$semestoque;
                $data['mensagem'] = "O produto \"$produtonome\" não tem estoque suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
            }
            //$data['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao." - Status nota: ".$pedidoresultado;
            //$data['mensagem'] .= $string;
            //echo json_encode($data);
            $this->load->view('pagamentopixview', $data);
        }

        function pixdinamico(){
            $this->load->library('my_pix');
            $this->load->model('pagamentomodel', 'modelo');
            $token = md5(time());
            $data['token'] = $token;
            $this->session->set_userdata('token',$token);
			$produto = $this->modelo->produto($this->input->post('produto'));
			if(empty($produto[0]->usuariooff)){
				$this->my_acesso->logged();
			}
			$this->my_configuracao->confSess();                      
            
            $semestoque = 0;
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            
            $item = $this->modelo->item($this->session->userdata('id'), $this->input->post('carrinho'));
            
            foreach ($item as $row) {
    
                $produto = $this->modelo->produto($row->produto);
                
                if($produto[0]->qtdade != '-1'){
                    if(($produto[0]->qtdade_saldo-$row->qtdade) < 0){
                        $semestoque = $row->produto;
                        $produtonome = $row->produtonome;
                    }
                    if($row->cupom && ($row->cupom_qtdade-$row->cupom_utilizado) < $row->qtdade){
                        $semestoquecupom = $row->produto;
                        $produtonome = $row->produtonome;
					}
                }
            }
            
            if(empty($semestoque)){
            	
	            if(empty($semestoquecupom)){
	                $configuracao = $this->modelo->configuracao();
            	
		            $url_autenticacao = "url-autenticacao";
					$retorno['status'] = '';
					$retorno['url_autenticacao'] = '';
					$forma_pagamento = $this->modelo->pagamentoforma($this->input->post("pagamentoforma"));
	                $pagamentoTotal = $this->modelo->pagamentoTotal($this->session->userdata('id'), $this->input->post('carrinho')); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
	
					if($this->input->post('carrinho')){
						$id = $this->input->post('carrinho'); //ID a compra, geralmente alguma chave primária.
					}else{
						$id = $this->session->userdata('id'); //ID a compra, geralmente alguma chave primária.
					}
	                
	                $valor = $pagamentoTotal[0]->total;
	                $txid = "MEDPLAY12345789".sprintf("%011d", $item[0]->id);

					if($configuracao[0]->pagamento_producao){
                        
                        //Ambiente de produção
                        $url = $configuracao[0]->pix_url;
                        $client_id = $configuracao[0]->pix_client_id; //Cliente ID do Pix. Em produção.
                        $client_secret = $configuracao[0]->pix_client_secret; //Cliente secret do Pix. Em produção.
                        if(stristr(__FILE__, 'desenvolvimento')) {
                            $certificado = $_SERVER['DOCUMENT_ROOT'].'/desenvolvimento/site/iportal/public/biblioteca-de-arquivos/unidade/'.$configuracao[0]->pix_certificado; //Certificado do Pix em produção.
                        } else {
                            $certificado = $_SERVER['DOCUMENT_ROOT'].'/site/iportal/public/biblioteca-de-arquivos/unidade/'.$configuracao[0]->pix_certificado; //Certificado do Pix em produção.
                        }
                        $chave = $configuracao[0]->pix_chave;
                        $nome = $configuracao[0]->pix_nome;
                        $cidade = $configuracao[0]->pix_cidade;
						
					}else{
						
                        //Ambiente de homologação
                        $url = 'https://api-pix-h.gerencianet.com.br';
                        $client_id = 'Client_Id_8ef12d5c598ca7e93c171e4be338cd7e2035fb13'; //Cliente ID do Pix. Em produção.
                        $client_secret = 'Client_Secret_5f94e449d3fe4d219554477437c16514e86e3678'; //Cliente secret do Pix. Em produção.
                        if(stristr(__FILE__, 'desenvolvimento')) {
                            $certificado = $_SERVER['DOCUMENT_ROOT'].'/desenvolvimento/site/application/libraries/pix/files/certificates/certificadopix.pem'; //Certificado do Pix em produção.
                        } else {
                            $certificado = $_SERVER['DOCUMENT_ROOT'].'/site/application/libraries/pix/files/certificates/certificadopix.pem'; //Certificado do Pix em produção.
                        }
                        $chave = '12345678909';
                        $nome = 'Michaell Stroid Lima e Silva';
                        $cidade = 'São Francisco do Sul';
                    	                
					}

					$pix = $this->my_pix->create_pix_dinamico($url, $client_id, $client_secret, $certificado, $valor, $chave, $produto[0]->titulo, $nome, $cidade);
					/*
					echo "<pre>";
					echo $url."<br/>";
					echo $client_id."<br/>";
					echo $client_secret."<br/>";
					echo $certificado."<br/>";
					echo $valor."<br/>";
					echo $chave."<br/>";
					echo $produto[0]->titulo."<br/>";
					echo $nome."<br/>";
					echo $cidade."<br/>";
					echo $item[0]->id."<br/>";
					
					print_r($pix);
					*/
					
					if($pix['payloadQrCode']){
					    
					    $pedido = $this->modelo->addPedido($pix[txid], $valor, $forma_pagamento[0]->id, '9', $this->input->post('carrinho'));
					    
                        if($pedido){
                            $data['payloadQrCode'] = $pix['payloadQrCode'];
                            $data['qrcode'] = $this->my_pix->create_qrcode($pix['payloadQrCode']);
                            $data['mensagem'] = 'Após o pagamento do '.$produto[0]->titulo.' clique em "Processar pagamento".';
                        	$data['url'] = base_url()."minhascompras";
                			$data['pedido'] = $this->modelo->pedido($pix[txid]);
                			$data['pedidoitem'] = $this->modelo->pedidoitem($data['pedido'][0]->id);
                            $data['pagamentoTotal'] = $pagamentoTotal;
                            $data['pagamentoforma'] = $forma_pagamento;
                        }else{
                            $data['mensagem'] = "Houve um erro ao tentar gerar o Pix o produto \"$produtonome\". Por favor contactar o administrador do site.";
                        	$data['url'] = base_url()."produto/id/".$semestoquecupom;                
                        }
                    }else{
                        $retorno['mensagem'] = 'Erro ao tentar gerar Pix';
                        $retorno['resultado'] = false;
                    }
                }else{
                	$data['url'] = base_url()."produto/id/".$semestoquecupom;
                    $data['mensagem'] = "O produto \"$produtonome\" não tem cupons de desconto suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
                }
                
            } else {
            	$data['url'] = base_url()."produto/id/".$semestoque;
                $data['mensagem'] = "O produto \"$produtonome\" não tem estoque suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
            }
            //$data['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao." - Status nota: ".$pedidoresultado;
            //$data['mensagem'] .= $string;
            //echo json_encode($data);
            $this->load->view('pagamentopixview', $data);
        }

        function pixautoriza(){
            $this->my_acesso->token();
            $this->load->library('my_pix');
            $this->load->model('pagamentomodel', 'modelo');
			$pedido = $this->modelo->pedido($this->input->post('tid'));
			$this->my_configuracao->confSess();
            
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            
            $configuracao = $this->modelo->configuracao();
    		if($configuracao[0]->pagamento_producao){
                
                $url = $configuracao[0]->pix_url;
                $client_id = $configuracao[0]->pix_client_id; //Cliente ID do Pix em produção.
                $client_secret = $configuracao[0]->pix_client_secret; //Cliente secret do Pix em produção.
                if(stristr(__FILE__, 'desenvolvimento')) {
                    $certificado = $_SERVER['DOCUMENT_ROOT'].'/desenvolvimento/site/iportal/public/biblioteca-de-arquivos/unidade/'.$configuracao[0]->pix_certificado;
                } else {
                    $certificado = $_SERVER['DOCUMENT_ROOT'].'/site/iportal/public/biblioteca-de-arquivos/unidade/'.$configuracao[0]->pix_certificado; //Certificado do Pix em produção.
                }
    			
    		}else{
    			
                //Ambiente de homologação
                $url = 'https://api-pix-h.gerencianet.com.br';
                $client_id = 'Client_Id_8ef12d5c598ca7e93c171e4be338cd7e2035fb13'; //Cliente ID do Pix em produção.
                $client_secret = 'Client_Secret_5f94e449d3fe4d219554477437c16514e86e3678'; //Cliente secret do Pix em produção.
                if(stristr(__FILE__, 'desenvolvimento')) {
                    $certificado = $_SERVER['DOCUMENT_ROOT'].'/desenvolvimento/site/application/libraries/pix/files/certificates/certificadopix.pem';
                } else {
                    $certificado = $_SERVER['DOCUMENT_ROOT'].'/site/application/libraries/pix/files/certificates/certificadopix.pem'; //Certificado do Pix em produção.
                }
            	                
    		}

		    $pix = $this->my_pix->consult_pix($url, $client_id, $client_secret, $certificado, $pedido[0]->tid);
			
			//$data['pix'] = $pix;
			
			if(($pix['status'] == 'CONCLUIDA' && $pix['valor']['original'] == $pix['pix'][0]['valor'])){
			    
			    $pixautoriza = $this->modelo->pixautoriza('1', $pedido);
			    
                if($pixautoriza){
                    $data['mensagem'] = 'Pagamento confirmado.';
                    $data['resultado'] = true;
                }else{
                    $data['mensagem'] = "O pagamento foi confirmado, mas houve erro ao gerar o pedido. Contate o administrador do site.";
                	$data['url'] = base_url()."produto/id/".$semestoquecupom;                
                }
            }elseif($pix['status'] == 'ATIVA'){
                $data['mensagem'] = 'Pagamento pendente.';
                $data['resultado'] = false;
            }else{
                $data['mensagem'] = 'Pagamento não efetuado';
                $data['resultado'] = false;
            }
            
            //$data['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao." - Status nota: ".$pedidoresultado;
            //$data['mensagem'] .= $string;
            echo json_encode($data);
        }

        function pagseguro(){
            
            ini_set('error_reporting', E_STRICT);
            //error_reporting(E_ALL);
			//ini_set("display_errors", 1 );
			
            $this->my_acesso->logged();
            //$this->my_acesso->token();                        
            
            $semestoque = 0;
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            $this->load->model('pagamentomodel', 'modelo');
            
            $item = $this->modelo->item($this->session->userdata('id'),$this->session->userdata('carrinho'));
            
            foreach ($item as $row) {
    
                $produto = $this->modelo->produto($row->produto);
                
                if(($produto[0]->qtdade_saldo-$row->qtdade) < 0){
                    $semestoque = $row->produto;
                    $produtonome = $row->produtonome;
                }
            	if($row->cupom && ($row->cupom_qtdade-$row->cupom_utilizado) < $row->qtdade){
                    $semestoquecupom = $row->produto;
                    $produtonome = $row->produtonome;
				}
				
            }
            if(empty($semestoque)){
            	
                if(empty($semestoquecupom)){
                    
                    $url_autenticacao = "url-autenticacao";
					$retorno['status'] = '';
					$retorno['url_autenticacao'] = '';
					$forma_pagamento = $this->modelo->pagamentoforma($this->input->post("pagamentoforma"));
                    $pagamentoTotal = $this->modelo->pagamentoTotal(); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
                    
                    $id = $this->session->userdata('id'); //ID a compra, geralmente alguma chave primária.
                    
                    $valor_total = number_format(floatval($pagamentoTotal[0]->total),2,'.','');
                    
                    $valorsemponto = str_replace(",", "",str_replace(".", "", $valor_total)); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
                    
                    $valor_frete = number_format(floatval($pagamentoTotal[0]->totalfrete),2,'.','');
                    
                    $valorfretesemponto = str_replace(",", "",str_replace(".", "", $valor_frete)); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
                    	                
                    $urlRetorno = base_url()."pagamento/autorizapagseguro/".$forma_pagamento[0]->id."/";
                    $urlNotificacao = base_url()."pagamento/notificapagseguro/";
                    
                    $configuracao = $this->modelo->configuracao();
					
					if($configuracao[0]->pagamento_producao){
						$ambiente = true; 
					}else{
						$ambiente = false; 
					}
					
					if($ambiente){
		            
		                //Ambiente de produção
						$email = $forma_pagamento[0]->pagseguro_email;
						$token = $forma_pagamento[0]->pagseguro_token;
						$url = 'https://ws.pagseguro.uol.com.br/v2/checkout/'.$tid.'?email=' . $email . '&token=' . $token;						
					}else{
						
		                //Ambiente de testes
						$email = $forma_pagamento[0]->pagseguro_email;
						$token = $forma_pagamento[0]->pagseguro_token;
						$url = 'https://ws.sandbox.pagseguro.uol.com.br/v2/checkout/'.$tid.'?email=' . $email . '&token=' . $token;		
					}	

	                $string = "<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>  
					<checkout>  
					    <currency>BRL</currency>  
					    <items>";
						
					foreach ($item as $row) {  
						$string .= "
					        <item>  
					            <id>".$row->id."</id>  
					            <description>".$row->produtonome."</description>  
					            <amount>".$row->valorunitario."</amount>  
					            <quantity>".$row->qtdade."</quantity>  
					        </item>";
						}
					
					$string .= "  
					    </items>";
					if($valor_frete>0){
					$string .= "  
						<shipping>
							<type>3</type>
							<cost>$valor_frete</cost>
					    </shipping>";
					}					    
					$string .= "  
					    <redirectURL>$urlRetorno</redirectURL> 
					    <notificationURL>$urlNotificacao</notificationURL> 
					</checkout>";
	                //exit($string);
	
						$curl = curl_init($url);
						curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
						curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
						curl_setopt($curl, CURLOPT_HTTPHEADER, Array('Content-Type: application/xml; charset=ISO-8859-1'));
						curl_setopt($curl, CURLOPT_POSTFIELDS, $string);
						$resultado = curl_exec($curl);
	                    curl_close($curl);
	                    $xml = simplexml_load_string($resultado);
	
                   if($xml->code){
                    	if($this->modelo->insereTid($xml->code, $this->session->userdata('id'))){
                    		if($ambiente){
								$retorno['url_autenticacao'] = "https://pagseguro.uol.com.br/v2/checkout/payment.html?code=".$xml->code;;
							}else{
								$retorno['url_autenticacao'] = "https://sandbox.pagseguro.uol.com.br/v2/checkout/payment.html?code=".$xml->code;;
							}
                            $retorno['resultado'] = true;
                        }else{
                            $retorno['mensagem'] = 'Houve um erro na transação. A transação não foi processada. Nos ajude a resolver esse problema enviando-nos um contato. Obrigado.';
                            $retorno['resultado'] = false;
                    	}
                    }else{
                        $retorno['mensagem'] = "Houve um erro de conexão com o PagSeguro.";
                        $retorno['resultado'] = false;
                    }
	            }else{
	            	$retorno['url_autenticacao'] = base_url()."produto/id/".$semestoquecupom;
	                $retorno['mensagem'] = "O produto \"$produtonome\" não tem cupons de desconto suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
	                $retorno['resultado'] = false;
	            }
                
            }else{
            	$retorno['url_autenticacao'] = base_url()."produto/id/".$semestoque;
                $retorno['mensagem'] = "O produto \"$produtonome\" não tem estoque suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
                $retorno['resultado'] = false;
            }
            //$retorno['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao;
            $retorno['mensagem'] .= $string." - url: ".$url;
            echo json_encode($retorno);
        }

        function autorizapagseguro($fpag){

            $semestoque = 0;
            ini_set('error_reporting', E_STRICT);
			
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            $this->load->model('pagamentomodel', 'modelo');

            $usuario = $this->modelo->usuario();
			
			if($this->input->get("transaction_id")){
				
				$tid = $this->input->get("transaction_id");
					
                $id = $this->session->userdata('id'); //ID a compra, geralmente alguma chave primária.
	
	            $pagamentoTotal = $this->modelo->pagamentoTotal(); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
				$forma_pagamento = $this->modelo->pagamentoforma($fpag);
				
                $valor_total = number_format(floatval($pagamentoTotal[0]->total),2,'.','');

                $valorsemponto = str_replace(",", "",str_replace(".", "", $valor_total)); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
			    
                $configuracao = $this->modelo->configuracao();
				
				if($configuracao[0]->pagamento_producao){
					$ambiente = true; 
				}else{
					$ambiente = false; 
				}
				
				if($ambiente){
	            
	                //Ambiente de produção
					$email = $forma_pagamento[0]->pagseguro_email;
					$token = $forma_pagamento[0]->pagseguro_token;
					$url = 'https://ws.pagseguro.uol.com.br/v3/transactions/'.$tid.'?email=' . $email . '&token=' . $token;						
				}else{
					
	                //Ambiente de testes
					$email = $forma_pagamento[0]->pagseguro_email;
					$token = $forma_pagamento[0]->pagseguro_token;
					$url = 'https://ws.sandbox.pagseguro.uol.com.br/v3/transactions/'.$tid.'?email=' . $email . '&token=' . $token;						
				}	
	
                $curl = curl_init($url);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				$resultado = curl_exec($curl);
                $xml = simplexml_load_string($resultado);
                                            
                if(isset($xml->status) && $xml->status == '3'){
                	
                    if($this->modelo->addPedido($tid, $valor_total, $forma_pagamento[0]->id)){
                        $data['mensagem'] = 'Transação autorizada pela operadora.';
						$data['mensagemredirect'] = "Você está sendo redirecionado para suas compras em ";
						$data['url'] = base_url()."minhascompras";
                        $data['resultado'] = true;
                    }else{
                        $data['mensagem'] = 'O pagamento foi processado com sucesso. Mas houve um erro ao tentar gerar o pedido, por favor contato o administrador do sistema.';
						$data['mensagemredirect'] = "Você está sendo redirecionado para suas compras em ";
						$data['url'] = base_url()."minhascompras";
                        $data['resultado'] = true;
                    }
                }elseif(isset($xml->status) && ($xml->status == '2' || $xml->status == '1')){
                	
                    if($this->modelo->addPedido($tid, $valor_total, $forma_pagamento[0]->id, '6')){
                        $data['mensagem'] = 'Transação em análise pela adminstradora.';
						$data['mensagemredirect'] = "Você está sendo redirecionado para suas compras em ";
						$data['url'] = base_url()."minhascompras";
                        $data['resultado'] = true;
                    }else{
                        $data['mensagem'] = 'O pagamento foi processado com sucesso. Mas houve um erro ao tentar gerar o pedido, por favor contato o administrador do sistema.';
						$data['mensagemredirect'] = "Você está sendo redirecionado para suas compras em ";
						$data['url'] = base_url()."minhascompras";
                        $data['resultado'] = true;
                    }
                }else{

                    $data['mensagem'] = "Transação não autorizada.<br/>";
                    $data['resultado'] = false;
					$this->modelo->insereTid("", $id);
					$data['url'] = base_url()."carrinho";
					$data['mensagemredirect'] = "Por favor, verifique os dados junto ao PagSeguro ou tente novamente.<br/>Você será redirecionado para o carrinho de compras em ";
            	}       
				
			}else{
                $data['mensagem'] = "Não existem processamentos de compras. Obrigado.";                
                $data['resultado'] = false;
				$data['url'] = base_url()."carrinho";
				$data['mensagemredirect'] = "Por favor, verifique os dados junto ao PagSeguro ou tente novamente.<br/>Você será redirecionado para o seu carrinho de compras em ";
			}
            $data['menu_id'] = '15';
            $this->load->view('pagamentoresultadoview', $data);
        }

        function notificapagseguro(){

            //ini_set('error_reporting', E_STRICT);
            //error_reporting(E_ALL);
			//ini_set("display_errors", 1 );
            			
            $this->load->model('pagamentomodel', 'modelo');
			
			if($this->input->post("notificationCode")){
				
				
				$notificationCode = $this->input->post("notificationCode");
				
				$forma_pagamento = $this->modelo->pagamentoforma('3');
				
                $configuracao = $this->modelo->configuracao();
				
				if($configuracao[0]->pagamento_producao){
					$ambiente = true; 
				}else{
					$ambiente = false; 
				}
				
				if($ambiente){
	            
	                //Ambiente de produção
					$email = $forma_pagamento[0]->pagseguro_email;
					$token = $forma_pagamento[0]->pagseguro_token;
					$url = 'https://ws.pagseguro.uol.com.br/v3/transactions/notifications/'.$notificationCode.'?email=' . $email . '&token=' . $token;						
				}else{
					
	                //Ambiente de testes
					$email = $forma_pagamento[0]->pagseguro_email;
					$token = $forma_pagamento[0]->pagseguro_token;
					$url = 'https://ws.sandbox.pagseguro.uol.com.br/v3/transactions/notifications/'.$notificationCode.'?email=' . $email . '&token=' . $token;						
				}	
	
                $curl = curl_init($url);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				$resultado = curl_exec($curl);
                $xml = simplexml_load_string($resultado);
                                            
                if(isset($xml->status) && $xml->status == '3'){
                   $this->modelo->altPedidoPagseguro($xml->code, '1');
                }elseif(isset($xml->status) && $xml->status == '2'){
                	
                }else{
                   $this->modelo->altPedidoPagseguro($xml->code, '7');
            	}       
			}
        }

        function paypal(){
            
            ini_set('error_reporting', E_STRICT);
            $this->my_acesso->logged();
            //$this->my_acesso->token();                        
            
            $semestoque = 0;
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            $this->load->model('pagamentomodel', 'modelo');
            
            $item = $this->modelo->item($this->session->userdata('id'));
            
            foreach ($item as $row) {
    
                $produto = $this->modelo->produto($row->produto);
                
                if(($produto[0]->qtdade_saldo-$row->qtdade) < 0){
                    $semestoque = $row->produto;
                    $produtonome = $row->produtonome;
                }
            	if($row->cupom && ($row->cupom_qtdade-$row->cupom_utilizado) < $row->qtdade){
                    $semestoquecupom = $row->produto;
                    $produtonome = $row->produtonome;
				}
				
            }
            
            if(empty($semestoque)){
            	
	            if(empty($semestoquecupom)){
            	
		            $url_autenticacao = "url-autenticacao";
					$retorno['status'] = '';
					$retorno['url_autenticacao'] = '';
					$forma_pagamento = $this->modelo->pagamentoforma($this->input->post("pagamentoforma"));
	                $pagamentoTotal = $this->modelo->pagamentoTotal(); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
	
	                $id = $this->session->userdata('id'); //ID a compra, geralmente alguma chave primária.
	                
	                $valor_total = number_format(floatval($pagamentoTotal[0]->total),2,'.','');
		
	                $valor_frete = number_format(floatval($pagamentoTotal[0]->totalfrete),2,'.','');

	                $configuracao = $this->modelo->configuracao();
					
					if($configuracao[0]->pagamento_producao){
						//Vai usar o Sandbox, ou produção?
						$sandbox = false;
					}else{
						//Vai usar o Sandbox, ou produção?
						$sandbox = true;
					}
					  
					//Baseado no ambiente, sandbox ou produção, definimos as credenciais
					//e URLs da API.
					if ($sandbox) {
						//credenciais da API para o Sandbox
						$user = $forma_pagamento[0]->paypal_usuario;
						$pswd = $forma_pagamento[0]->paypal_senha;
						$signature = $forma_pagamento[0]->paypal_assinatura;
					  
						//URL da PayPal para redirecionamento, não deve ser modificada
						$paypalURL = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
					} else {
						//credenciais da API para produção
						$user = $forma_pagamento[0]->paypal_usuario;
						$pswd = $forma_pagamento[0]->paypal_senha;
						$signature = $forma_pagamento[0]->paypal_assinatura;
					  
						//URL da PayPal para redirecionamento, não deve ser modificada
						$paypalURL = 'https://www.paypal.com/cgi-bin/webscr';
					}
					  
					//Campos da requisição da operação SetExpressCheckout, como ilustrado acima.
					$requestNvp = array(
						'USER' => $user,
						'PWD' => $pswd,
						'SIGNATURE' => $signature,
					  
						'VERSION' => '108.0',
						'METHOD'=> 'SetExpressCheckout',
					  
						'PAYMENTREQUEST_0_PAYMENTACTION' => 'SALE',
						'PAYMENTREQUEST_0_AMT' => $valor_total,
						'PAYMENTREQUEST_0_CURRENCYCODE' => 'BRL',
						'PAYMENTREQUEST_0_ITEMAMT' => $valor_total,
						'PAYMENTREQUEST_0_INVNUM' => '1234'
						);
						
					foreach ($item as $key => $row) {
						$requestNvp['L_PAYMENTREQUEST_0_NAME'.$key] = $row->produtonome;
						$requestNvp['L_PAYMENTREQUEST_0_DESC'.$key] = $row->produtonome;
						$requestNvp['L_PAYMENTREQUEST_0_AMT'.$key] = $row->valorunitario;
						$requestNvp['L_PAYMENTREQUEST_0_QTY'.$key] = $row->qtdade;
					}

					if($valor_frete>0){
						$requestNvp['L_SHIPPINGOPTIONAMOUNTn'] = $valor_frete;
					}					    
					
					$requestNvp['RETURNURL'] = base_url()."pagamento/autorizapaypal/".$forma_pagamento[0]->id."/";
					$requestNvp['CANCELURL'] = base_url()."carrinho";
					$requestNvp['BUTTONSOURCE'] = 'BR_EC_EMPRESA';
					  
					//Envia a requisição e obtém a resposta da PayPal
					$responseNvp = $this->sendNvpRequest($requestNvp, $sandbox);
					
					 
					//Se a operação tiver sido bem sucedida, redirecionamos o cliente para o
					//ambiente de pagamento.
					if (isset($responseNvp['ACK']) && $responseNvp['ACK'] == 'Success') {
						$query = array(
							'cmd'    => '_express-checkout',
							'token'  => $responseNvp['TOKEN']
						);
					  
						$redirectURL = sprintf('%s?%s', $paypalURL, http_build_query($query));
						
						if($this->modelo->insereTid($responseNvp['TOKEN'], $this->session->userdata('id'))){
							$retorno['url_autenticacao'] = $redirectURL;
			                $retorno['resultado'] = true;
                        }else{
                            $retorno['mensagem'] = 'Houve um erro na transação. A transação não foi processada. Nos ajude a resolver esse problema enviando-nos um contato. Obrigado.';
                            $retorno['resultado'] = false;
                    	}
					  
						//header('Location: ' . $redirectURL);
						//redirect($redirectURL, 'refresh');
						//$retorno['mensagem'] = "id: ".$responseNvp['PAYMENTREQUEST_0_TRANSACTIONID']." - status: ".$responseNvp['CHECKOUTSTATUS']." - token: ".$responseNvp['TOKEN'];
						
					} else {
						//redirect(base_url(), 'refresh');
						//Opz, alguma coisa deu errada.
						//Verifique os logs de erro para depuração.
						$retorno['resultado'] = false;
						$retorno['mensagem'] = "Houve um erro de conexão com o PayPal.".$responseNvp['PAYMENTINFO_0_TRANSACTIONID'];
					}
						
	            }else{
	            	$retorno['url_autenticacao'] = base_url()."produto/id/".$semestoquecupom;
	                $retorno['mensagem'] = "O produto \"$produtonome\" não tem cupons de desconto suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
	                $retorno['resultado'] = false;
	            }
                
            }else{
            	$retorno['url_autenticacao'] = base_url()."produto/id/".$semestoque;
                $retorno['mensagem'] = "O produto \"$produtonome\" não tem estoque suficiente para esta compra.<br/>Você está sendo redirecionado para a página do produto em <span class='count'>10</span> segundos.";                
                $retorno['resultado'] = false;
            }
            //$retorno['mensagem'] .= " - Status: ".$xml->status." - Código Captura: ".$xml->captura->codigo." - Código aturorização: ".$xml->autorizacao->codigo." - TID: ".$xml->tid." - URL autenticação: ".$xml->$url_autenticacao;
            //$retorno['mensagem'] .= $string;
            echo json_encode($retorno);
        }

        function autorizapaypal($fpag){

            $semestoque = 0;
            ini_set('error_reporting', E_STRICT);
			
            $retorno['mensagem'] = "";
            $retorno['resultado'] = false;
            $this->load->model('pagamentomodel', 'modelo');

			$item = $this->modelo->item($this->session->userdata('id'),$this->session->userdata('carrinho'));
			$tid = $item[0]->tid;
			
			if($tid){
	
                $id = $this->session->userdata('id'); //ID a compra, geralmente alguma chave primária.
	
	            $pagamentoTotal = $this->modelo->pagamentoTotal(); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
				$forma_pagamento = $this->modelo->pagamentoforma($fpag);
				
				$valor_total = number_format(floatval($pagamentoTotal[0]->total),2,'.','');

                $valorsemponto = str_replace(",", "",str_replace(".", "", $valor_total)); //Enviando o valor de R$22,00, observa que não existe separador de milhar e de centavos
			    
                $configuracao = $this->modelo->configuracao();
				
				if($configuracao[0]->pagamento_producao){
					//Vai usar o Sandbox, ou produção?
					$sandbox = false;
				}else{
					//Vai usar o Sandbox, ou produção?
					$sandbox = true;
				}
				  
				//Baseado no ambiente, sandbox ou produção, definimos as credenciais
				//e URLs da API.
				if ($sandbox) {
					//credenciais da API para o Sandbox
					$user = $forma_pagamento[0]->paypal_usuario;
					$pswd = $forma_pagamento[0]->paypal_senha;
					$signature = $forma_pagamento[0]->paypal_assinatura;
				  
					//URL da PayPal para redirecionamento, não deve ser modificada
					$paypalURL = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
				} else {
					//credenciais da API para produção
					$user = $forma_pagamento[0]->paypal_usuario;
					$pswd = $forma_pagamento[0]->paypal_senha;
					$signature = $forma_pagamento[0]->paypal_assinatura;
				  
					//URL da PayPal para redirecionamento, não deve ser modificada
					$paypalURL = 'https://www.paypal.com/cgi-bin/webscr';
				}
				  
				//Campos da requisição da operação SetExpressCheckout, como ilustrado acima.
				$requestNvp = array(
				    'USER' => $user,
				    'PWD' => $pswd,
				    'SIGNATURE' => $signature,
				  
				    'METHOD' => 'GetExpressCheckoutDetails',
				    'VERSION' => '108',
				  
				    'TOKEN' => $this->input->get('token')
					);
				  
				//Envia a requisição e obtém a resposta da PayPal
				$responseNvp = $this->sendNvpRequest($requestNvp, $sandbox);
                                            
                if(isset($responseNvp['ACK']) && $responseNvp['ACK'] == 'Success' && $responseNvp['CHECKOUTSTATUS'] == "PaymentActionCompleted" || true){
                	
                    if($this->modelo->addPedido($responseNvp['TOKEN'], $valor_total, $forma_pagamento[0]->id)){
                        $data['mensagem'] = 'Transação autorizada pela operadora.';
						$data['mensagemredirect'] = "Você está sendo redirecionado para suas compras em ";
						$data['url'] = base_url()."minhascompras";
                        $data['resultado'] = true;
                    }else{
                        $data['mensagem'] = 'O pagamento foi processado com sucesso. Mas houve um erro ao tentar gerar o pedido, por favor contato o administrador do sistema.';
						$data['mensagemredirect'] = "Você está sendo redirecionado para suas compras em ";
						$data['url'] = base_url()."minhascompras";
                        $data['resultado'] = true;
                    }
                }else{
					/*$data['mensagem'] = "Desculpe, mas não foi possível concluir a compra. Algum dos motivos abaixo podem ter ocorrido:<br/><br/>
					
					1. Site do banco não localizado;<br/>
					2. Erro nos dados do cartão;<br/>
					3. Cancelamento manual do pagamento;<br/>
					4. Lentidão na conexão de internet;<br/>
					5. Saldo indisponível.<br/><br/>";*/

                    $data['mensagem'] = "Transação não autorizada.<br/>";
                    $data['resultado'] = false;
					$this->modelo->insereTid("", $id);
					$data['url'] = base_url()."carrinho";
					$data['mensagemredirect'] = "Por favor, verifique os dados junto a Paypal ou tente novamente.<br/>Você será redirecionado para o carrinho de compras em ";
            	}       
				
			}else{
                $data['mensagem'] = "Não existem processamentos de compras. Obrigado.";                
                $data['resultado'] = false;
				$data['url'] = base_url()."carrinho";
				$data['mensagemredirect'] = "Por favor, verifique os dados junto a Paypal ou tente novamente.<br/>Você será redirecionado para o seu carrinho de compras em ";
			}
            //$data['mensagem'] .= "Respostas: ".$responseNvp['ACK']." - Status: ".$responseNvp['CHECKOUTSTATUS']." - forma de pagamento: ".$forma_pagamento[0]->id;
            //$data['mensagem'] .= $stringcancela;
            //$data['mensagem'] .= " - Status: ".$xmlcancela->status;
            $data['menu_id'] = '15';
            $this->load->view('pagamentoresultadoview', $data);
        }

        
		function sendNvpRequest(array $requestNvp, $sandbox = false)
		{
			//Endpoint da API
			$apiEndpoint  = 'https://api-3t.' . ($sandbox? 'sandbox.': null);
			$apiEndpoint .= 'paypal.com/nvp';

			//Executando a operação
			$curl = curl_init();
		  
			curl_setopt($curl, CURLOPT_URL, $apiEndpoint);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($requestNvp));
		  
			$response = urldecode(curl_exec($curl));
		  
			curl_close($curl);
		  
			//Tratando a resposta
			$responseNvp = array();
		  
			if (preg_match_all('/(?<name>[^\=]+)\=(?<value>[^&]+)&?/', $response, $matches)) {
				foreach ($matches['name'] as $offset => $name) {
					$responseNvp[$name] = $matches['value'][$offset];
				}
			}
		  	
			//Verificando se deu tudo certo e, caso algum erro tenha ocorrido,
			//gravamos um log para depuração.
			if (isset($responseNvp['ACK']) && $responseNvp['ACK'] != 'Success') {
				for ($i = 0; isset($responseNvp['L_ERRORCODE' . $i]); ++$i) {
					$message = sprintf("PayPal NVP %s[%d]: %s\n",
									   $responseNvp['L_SEVERITYCODE' . $i],
									   $responseNvp['L_ERRORCODE' . $i],
									   $responseNvp['L_LONGMESSAGE' . $i]);
		  
					error_log($message);
				}
			}
		  
			return $responseNvp;
		}
		
    }