<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Login extends MX_Controller {

    function __construct() {
        parent::__construct();
    }

    function index(){

        // VALIDAÇÃO DE RULES
        $this->load->library('form_validation');
        $this->form_validation->set_rules('email', 'E-mail', 'required');
        $this->form_validation->set_rules('senha', 'Senha', 'required');
        $this->form_validation->set_error_delimiters('<p class="error">', '</p>');


       // BIBLIOTECA my_acesso
        $query = $this->my_acesso->validate();
        $data['mensagem'] = "";
        $data['id'] = "";
        
        if ($this->form_validation->run() == FALSE) {
            $data['id'] = $this->session->userdata('id');
        } else {
            if ($query) { // VERIFICA LOGIN E SENHA
                $data['id'] = $this->session->userdata('id');
            } else {
                $this->session->sess_destroy();
                $data['mensagem'] = "Usuário ou senha inválidos.".$query;
                $data['id'] = $this->session->userdata('id');
            }
        }
        echo json_encode($data);
    }

    function pagina(){
		$this->load->view('loginpaginaview');
    }

    function esqueceu(){
		$this->load->view('loginesqueceuview');
    }

    function curso($curso){
    	$this->load->model('loginmodel', 'modelo');
		$data['linha'] = $this->modelo->curso($curso);
		$this->session->unset_userdata('id');
		$this->session->set_userdata('curso', $curso);
		$this->load->view('logincursoview', $data);
    }

    function cursoesqueceu($curso){
		$data['curso'] = $curso;
		$this->load->view('logincursoesqueceuview', $data);
    }

}

