<!doctype html>
<html lang="pt-br">

<?php $this->load->view('includes/incHead'); ?>

<body>


    <div class="page-container">


<?php $this->load->view('includes/incHeader'); ?>


<main class="main-container">
    <div class="content-container page-contact">
        <div class="page-title-container" id="particles-js">
            <img class="title-picture" src="<?php echo base_url(); ?>iportal/public/biblioteca-de-arquivos/contatotitulo/<?php echo $contatotitulo[0]->imagem; ?>" alt="Contato">
            <h1 class="title"><?php echo $contatotitulo[0]->titulo; ?></h1>
            <p class="title-description">
                <?php echo $contatotitulo[0]->descricao; ?>
            </p>
        </div>

        <div class="page-contact-structure">
            <form id="form-contato" name="form-contato" class="contact-form tw-form">
                    <div class="form-input-container">
                        <input value="" type="text" name="nome" class="form-input" id="nome" placeholder="Digite seu nome">
                        <label for="tw-contact-nome" class="form-label">Nome</label>
                    </div>
                    <span class="mensagem-alerta" id="nomeStatus"></span><br/>
                    
                <div class="form-input-container">
                	<input value="" type="email" name="email" class="form-input" id="email" placeholder="Digite seu e-mail">
                    <label for="tw-contact-email" class="form-label">E-mail</label>
                </div>
                <span class="mensagem-alerta" id="emailStatus"></span><br/>

                    <div class="form-input-container">
                        <input value="" type="text" name="assunto" class="form-input" id="assunto" placeholder="Digite seu nome">
                        <label for="tw-contact-assunto" class="form-label">Assunto</label>
                    </div>
                    <span class="mensagem-alerta" id="assuntoStatus"></span><br/>

                <div class="form-input-container">
                    <textarea name="mensagem" rows="5" class="form-input textarea" id="mensagem" placeholder="Digite sua mensagem..." ></textarea>
                    <label for="tw-contact-mensagem" class="form-label">Mensagem</label>
                </div>
                <span class="mensagem-alerta" id="mensagemStatus"></span><br/>

                <div style="text-align: center;" class="submit-container">
                	<div id="msnStatus"></div>
                    <button type="button" onclick="SendContato();" class="tw-btn success upper">Enviar Mensagem</button>
                </div>
            </form>

            <div class="contact-method-container" >
                <div class="contact-method" >
                    <img class="contact-method-picture" src="https://d2k3pl8gdoo5hz.cloudfront.net/images/contact/whatsapp-logo.svg" alt="Envelope">
                    <h2 class="contact-method-title" >Central de atendimento. Esse é nosso melhor canal!</h2>
                    <a class="email-link bold" style="text-align: center;" href="mailto:<?php echo $contatodescricao[0]->texto; ?>" target="_top"><?php echo $contatodescricao[0]->texto; ?></a>
               </div>
            </div>
        </div>
    </div>
        </main>

<?php $this->load->view('includes/incFooter'); ?>

            </div>

<?php $this->load->view('includes/incScripts'); ?>

</body>
</html>


<script>
    
var ResetInput = function(){
    jQuery('input, textarea').each(function() {
        jQuery(this).val('').text('');
    });
};

var SendContato = function(){
    $('#emailStatus').html("");
    $('#nomeStatus').html("");
    $('#assuntoStatus').html("");
    $('#mensagemStatus').html("");
    var isValid = true;
    var msgForm = "";
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    if(!emailReg.test($('#form-contato [name=email]').val()) && $('#email').val() != ""){
        isValid = false;
        $('#emailStatus').html("E-mail Inválido. Tente novamente.<br />");
    }
    if($('#form-contato [name=email]').val() == ""){
        isValid = false;
        $('#emailStatus').html("E-mail é obrigatório.<br />");
    }
    if($('#form-contato [name=nome]').val() == ""){
        isValid = false;
        $('#nomeStatus').html("Nome é obrigatório.<br />");
    }
    if($('#form-contato [name=assunto]').val() == ""){
        isValid = false;
        $('#assuntoStatus').html("Assunto é obrigatório.<br />");
    }
    if($('#form-contato [name=mensagem]').val() == ""){
        isValid = false;
        $('#mensagemStatus').html("Mensagem é obrigatória.<br />");
    }

    if(isValid){
        var params = {
            'nome'      : $('#form-contato [name=nome]').val(),
            'email'     : $('#form-contato [name=email]').val(),
            'assunto'   : $('#form-contato [name=assunto]').val(),
            'unidade'   : '1',
            'mensagem'  : $('#form-contato [name=mensagem]').val()
        };
        $.ajax({
            beforeSend: function() {$(".jquery-waiting-base-container").waitingShow({modo:"slow"});},
            type: "POST",
            url: "<?php echo base_url();?>contato/salvar",
            data: params,
            success: function(response){
                if(response){
                    msgForm = "Contato enviado com sucesso.";
                    $('#msnStatus').html("<center><h4 class='color_green'>"+msgForm+"</h4></center>");
                }else{
                    msgForm = "Erro ao enviar contato.";
                    $('#msnStatus').html("<center><h4 class='color_red'>"+msgForm+"</h4></center>");        
                }
                ResetInput();
                $(".jquery-waiting-base-container").waiting({modo:"slow"});

            },
            error: function (xhr, ajaxOptions, thrownError){
                //xhr.status : 404, 303, 501...
                var error = null;
                switch(xhr.status)
                {
                    case "301":
                        error = "Erro de redirecionamento!";
                        break;
                    case "307":
                        error = "Erro, redirecionamento de servidor temporário!";
                        break;
                    case "400":
                        error = "Solicitação ruim!";
                        break;
                    case "404":
                        error = "Página não encontrada!";
                        break;
                    case "500":
                        error = "Servidor indisponível no momento!";
                        break;
                    default:
                        error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
                }
                if(error){
                    $('#msnStatus').html(error);
                    $('#msnStatus').html("<center><h4 class='color_red'>"+error+"</h4></center>");
                }
            }
        });
    }else{
        $('#msnStatus').html("<center><h4 class='color_red'>"+msgForm+"</h4></center>");        
    }
  
};
</script>
<style>
	.mensagem-alerta{
		color: red;
	}
</style>

</body>
</html>