<?php

class Carrinhomodel extends CI_Model {

    function __construct(){
        // Chama o construtor do Model
        parent::__construct();
    }

    public function carrinho(){
        $query = $this->db->query("SELECT und.nome unidadenome, prd.titulo, prd.qtdade_saldo, prd.qtdade_porcompra, prd.tipo_frete, prd.capa, prd.qtdade prdqtdade, car.* 
        							FROM carrinho car 
        							INNER JOIN produto prd ON prd.id = car.produto
        							LEFT JOIN unidade und ON und.id = car.unidade
        							WHERE car.usuario = '".$this->session->userdata('id')."'");
        return $query->result();        
    }

    public function uf(){
        $query = $this->db->get('uf');
        return $query->result();
    }
	
    public function produtoCupom(){
        $query = $this->db->query("SELECT cup.* FROM carrinho car         							
        							INNER JOIN cupom cup ON cup.produto = car.produto AND (cup.vencimento >= CURDATE() OR cup.vencimento = '0000-00-00' or ISNULL(cup.vencimento))
        							WHERE cup.status = '1' 
        							AND car.usuario = '".$this->session->userdata('id')."'");
        return $query->result();        
    }

    public function cupom($cupom, $produto){
        $query = $this->db->query("SELECT * FROM cupom 
        WHERE produto = '$produto' 
        AND cupom LIKE BINARY '$cupom' 
        AND status = '1'
        AND (vencimento >= CURDATE() OR vencimento = '0000-00-00' or ISNULL(vencimento))");
        return $query->result();        
    }
    
    public function cupomExiste($produto){
        $query = $this->db->query("SELECT cup.* FROM carrinho car         							
        							LEFT JOIN cupom cup ON cup.produto = car.produto AND (cup.vencimento >= CURDATE() OR cup.vencimento = '0000-00-00' or ISNULL(cup.vencimento))
        							WHERE cup.status = '1' 
        							AND car.produto = '$produto'");
        return $query->result();        
    }
    
    public function carrinhoTotal(){
        $query = $this->db->query("SELECT sum(car.valor) total FROM carrinho car INNER JOIN produto prd ON prd.id = car.produto WHERE car.usuario = '".$this->session->userdata('id')."'");
        return $query->result();        
    }
    
    public function lista_pagamentoforma(){
        $query = $this->db->query("SELECT * 
									FROM pagamentoforma 
									WHERE status = '1'
									and carrinho = '1'
									ORDER BY descricao");
        return $query->result();        
    }

    public function buscaFrete($cep, $produto){
        $query = $this->db->query("SELECT frf.* 
									FROM frete_faixa frf 
									INNER JOIN frete frt ON frt.id = frf.frete
									INNER JOIN produto prd ON prd.frete = frt.id AND prd.id = '$produto'
									WHERE frf.cep_inicial <= '$cep' 
									AND frf.cep_final >= '$cep' 
									AND frf.status = '1'
									AND frf.status = '1'");
        return $query->result();        
    }

	public function calulaFrete($id, $valor){
        $retorno = false;
        
        $this->db->set('frete', $valor); 
        $this->db->where('id',$id);
        if($this->db->update('carrinho')){
        	$retorno = true;
        	
        }
        return $retorno;
    }

    public function pedidoitem($pedido){
        $sql = "SELECT pei.*, prd.preco, prd.qtdade_vendida, prd.qtdade_bloqueada, prd.qtdade_saldo, prd.compra_unica, pdd.frete, prd.titulo
					FROM pedidoitem pei 
					inner join pedido pdd on pdd.id = pei.pedido
					INNER JOIN produto prd ON prd.id = pei.produto
					WHERE pei.pedido = '$pedido'";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }
        
    public function addCarrinho(){
        $retorno = 0;
        
        $itemExiste = $this->itemExiste();
        if(empty($itemExiste)){
			$produto = $this->produto();
			$cupom = $this->cupom($this->input->post('cupom'), $this->input->post('produto'));

            $this->db->set('produto', $this->input->post('produto'));     
            $this->db->set('usuario', $this->session->userdata('id'));   
			$this->db->set('filiacao', $this->input->post('filiacao'));
            $this->db->set('unidade', $this->input->post('unidade'));   
            $this->db->set('qtdade', $this->input->post('qtdade'));     
            $this->db->set('valorunitario', $this->input->post('valorunitario'));     
            $this->db->set('valor', $this->input->post('valor'));  
            $this->db->set('frete', $this->input->post('frete'));  

			if($this->input->post('cupom') && ($cupom[0]->cupom == $this->input->post('cupom'))){
				if($this->input->post('qtdade') > ($cupom[0]->qtdade - $cupom[0]->utilizado)){
					$this->db->set('cupom', '');  
				}else{
					$this->db->set('cupom', $this->input->post('cupom'));
				}
			}else{
				$this->db->set('cupom', $this->input->post('cupom'));  
			}

            if($this->db->insert('carrinho')){
            	
                $retorno = $this->db->insert_id();
				
				if($this->input->post('presente')){
	                $this->db->set('carrinho', $retorno);
	                $this->db->set('nome', $this->input->post('presentenome'));
	                $this->db->set('nascimento', substr($this->input->post('presentenascimento'), -4)."-".substr($this->input->post('presentenascimento'), 3, 2)."-".substr($this->input->post('presentenascimento'), 0, 2));
	                $this->db->set('email', $this->input->post('presenteemail'));
	                $this->db->set('telefone', $this->input->post('presentetelefone'));
	                $this->db->set('cpf', $this->input->post('presentecpf'));
	                $this->db->set('enviar', $this->input->post('presenteenviar'));
	                $this->db->set('mensagem', nl2br($this->input->post('presentemensagem')));
	                $this->db->insert('carrinho_presente');	
				}

				if($this->input->post('endereco')){
		         $this->db->set('usuario', $this->session->userdata('id'));   
					$this->db->set('carrinho', $retorno);
					$this->db->set('endereco', $this->input->post('endereco'));
					$this->db->set('bairro', $this->input->post('bairro'));
					$this->db->set('cidade', $this->input->post('cidade'));
					$this->db->set('uf', $this->input->post('uf'));
					$this->db->set('cep', $this->input->post('cep'));
					$this->db->insert('carrinho_frete');
				}
				
		        if(!empty($_POST['nome'])){
		            foreach($_POST['nome'] as $key => $n ) {
		                $this->db->set('carrinho', $retorno);
		                $this->db->set('numero', $key+1);
		                $this->db->set('nome', $_POST['nome'][$key]);
		                $this->db->set('nascimento', substr($_POST['nascimento'][$key], -4)."-".substr($_POST['nascimento'][$key], 3, 2)."-".substr($_POST['nascimento'][$key], 0, 2));
		                $this->db->set('email', $_POST['email'][$key]);
		                $this->db->set('telefone', $_POST['telefone'][$key]);
		                $this->db->set('cpf', $_POST['cpf'][$key]);
		                $this->db->set('enviar', $_POST['enviar'][$key]);
		                $this->db->insert('carrinho_participante');
		            }
		        }

		        if(!empty($_POST['formularioid'])){
		            foreach($_POST['formularioid'] as $key => $f ) {
			            $this->db->set('usuario', $this->session->userdata('id'));   
		                $this->db->set('carrinho', $retorno);
		                $this->db->set('campo', $_POST['formularioid'][$key]);
		                $this->db->set('descricao', $_POST['formulariodescricao'][$key]);
		                $this->db->insert('carrinho_formulario');
		            }
		        }
            }
        }else{
        	$this->db->set('filiacao', $this->input->post('filiacao'));
            $this->db->set('qtdade', $this->input->post('qtdade'));                 
            $this->db->set('valor', ($this->input->post('qtdade'))*$itemExiste[0]->valorunitario);
			$this->db->set('cupom', $this->input->post('cupom'));   
            $this->db->where('id',$itemExiste[0]->id);
            if($this->db->update('carrinho')){
                $retorno = $itemExiste[0]->id;
            }
        }
        return $retorno;
    }
    
    public function altCarrinho(){
        
        $retorno['resultado'] = false;
        $itemExiste = $this->itemExiste();
		$cupom = $this->cupom($this->input->post('cupom'), $this->input->post('produto'));
        if(!empty($itemExiste)){
        	if(!empty($cupom)){

        		if($this->input->post('qtdade') > ($cupom[0]->qtdade - $cupom[0]->utilizado)){
        			$this->db->set('qtdade', $this->input->post('qtdade'));
					$this->db->set('valorunitario', $itemExiste[0]->preco);
					$this->db->set('valor', $this->input->post('qtdade')*$itemExiste[0]->preco);
					$this->db->set('cupom', '');
					$retorno['valorunitario'] = $itemExiste[0]->preco;
					$retorno['valor'] = $this->input->post('qtdade')*$itemExiste[0]->preco;					
					$retorno['qtdade_disponivel'] = $cupom[0]->qtdade - $cupom[0]->utilizado;
					$retorno['mensagem'] = "<center><h4 class='color_red'>Há somente ".$retorno['qtdade_disponivel']." cupons de desconto disponíveis.</h4></center>";
	    		}else{
        			$this->db->set('qtdade', $this->input->post('qtdade'));
					$this->db->set('valorunitario', ($itemExiste[0]->preco-$cupom[0]->desconto));
					$this->db->set('valor', $this->input->post('qtdade')*($itemExiste[0]->preco-$cupom[0]->desconto));
					$this->db->set('cupom', $this->input->post('cupom'));
					$retorno['valorunitario'] = ($itemExiste[0]->preco-$cupom[0]->desconto);
					$retorno['valor'] = $this->input->post('qtdade')*($itemExiste[0]->preco-$cupom[0]->desconto);					
        		}            	 

			}else{
				$this->db->set('qtdade', $this->input->post('qtdade'));
				$this->db->set('valorunitario', $itemExiste[0]->preco);
        		$this->db->set('valor', $this->input->post('qtdade')*$itemExiste[0]->preco);
				$this->db->set('cupom', '');				
				$retorno['valorunitario'] = $itemExiste[0]->preco;
				$retorno['valor'] = $this->input->post('qtdade')*$itemExiste[0]->preco;	
				if($this->input->post('cupom')){
					$retorno['mensagem'] = "<center><h4 class='color_red'>Cupom inválido.</h4></center>";
	        	}
			}

            $this->db->where('id',$itemExiste[0]->id);
            if($this->db->update('carrinho')){
                $retorno['resultado'] = true;
            }
        }
        return $retorno;
    }
    
    public function excCarrinho(){
        $retorno = false;
        
        $this->db->where('id',$this->input->post('id'));
        if($this->db->delete('carrinho')){
	        $this->db->where('carrinho',$this->input->post('id'));
	        if($this->db->delete('carrinho_frete')){
	            $retorno = true;
	        }
        }
        return $retorno;
    }

    public function limpaCarrinho(){
        $retorno = false;
        
        $this->db->where('usuario',$this->session->userdata('id'));
        if($this->db->delete('carrinho')){
        	
			$this->db->where('usuario',$this->session->userdata('id'));
	        if($this->db->delete('carrinho_frete')){
	            $retorno = true;
	        }			
			$this->db->where('usuario',$this->session->userdata('id'));
	        if($this->db->delete('carrinho_formulario')){
	            $retorno = true;
	        }			
        }
        return $retorno;
    }

    
    public function itemExiste(){
        $query = $this->db->query("SELECT car.*, IF(pdu.unidade, pdu.preco, prd.preco) preco
        							FROM carrinho car 
        							INNER JOIN produto prd ON prd.id = car.produto 
        							LEFT JOIN produto_unidade pdu ON pdu.unidade = car.unidade AND pdu.produto = car.produto
        							WHERE car.usuario = '".$this->session->userdata('id')."' 
        							AND car.usuario != ''
        							AND car.produto = '".$this->input->post('produto')."' limit 1");
        return $query->result();        
    }
    
    public function produto(){
        $query = $this->db->query("SELECT prd.* FROM produto prd WHERE prd.id = '".$this->input->post('produto')."' limit 1");
        return $query->result();        
    }

    public function carrinho_compra_unica(){
        $query = $this->db->query("SELECT DISTINCT car.id FROM carrinho car
									INNER JOIN produto prd ON prd.id = car.produto
									WHERE prd.compra_unica = '1'
									AND car.usuario = '".$this->session->userdata('id')."'");
        return $query->result();        
    }

	public function excCarrinho_compra_unica($id){
        $retorno = false;
        
        $this->db->where('id',$id);
        if($this->db->delete('carrinho')){
        	$this->db->where('carrinho',$id);
        	if($this->db->delete('carrinho_frete')){
	            $retorno = true;
        	}
        }
        return $retorno;
    }
	    
	public function alterafrete(){
        $retorno = false;
        
		$this->db->set('endereco', $this->input->post('endereco'));
		$this->db->set('bairro', $this->input->post('bairro'));
		$this->db->set('cidade', $this->input->post('cidade'));
		$this->db->set('uf', $this->input->post('uf'));
		$this->db->set('cep', $this->input->post('cep'));
        $this->db->where('usuario', $this->session->userdata('id'));
        if($this->db->update('carrinho_frete')){
        	$retorno = true;
        }   
		
        return $retorno;
    }

	public function renovarcompra($item, $produto, $filiacao, $unidade, $qtdade, $valorunitario, $valor, $frete){
      $retorno = false;
      //$pedidoitem = $this->modelo->pedidoitem($this->input->post('pedido'));

      $this->db->set('produto', $produto);     
      $this->db->set('usuario', $this->session->userdata('id'));   
	  $this->db->set('filiacao', $filiacao);
      $this->db->set('unidade', $unidade);   
      $this->db->set('qtdade', $qtdade);     
      $this->db->set('valorunitario', $valorunitario);     
      $this->db->set('valor', $valor);  
      $this->db->set('frete', $frete);  
      if($this->db->insert('carrinho')){
      	$retorno = true;
      }  
		
        return $retorno;
    }
	    
    function tofloat($num) {
        $dotPos = strrpos($num, '.');
        $commaPos = strrpos($num, ',');
        $sep = (($dotPos > $commaPos) && $dotPos) ? $dotPos : 
            ((($commaPos > $dotPos) && $commaPos) ? $commaPos : false);

        if (!$sep) {
            return floatval(preg_replace("/[^0-9]/", "", $num));
        } 

        return floatval(
            preg_replace("/[^0-9]/", "", substr($num, 0, $sep)) . '.' .
            preg_replace("/[^0-9]/", "", substr($num, $sep+1, strlen($num)))
        );
    }

    
}
