<?php
require __DIR__.'/pix/vendor/autoload.php';
require __DIR__.'/pix/config-pix.php';

use \App\Pix\Api;
use \App\Pix\Payload;
use Mpdf\QrCode\QrCode;
use Mpdf\QrCode\Output;

class My_pix
{
    //Função para criação Pix dinâmico
    function create_pix_dinamico($url, $client_id, $client_secret, $certificado, $valor, $chave, $solicitacaoPagador, $nome, $cidade){
        $CI = & get_instance();
        //$solicitacaoPagador = preg_replace('/[0-9\@\.\;]+/', '', $solicitacaoPagador);
        $cpf = str_replace("-", "", str_replace(".", "", $CI->session->userdata('cpf')));
        $nome = substr($nome, 0, 25);
        $cidade = substr($cidade, 0, 15);

        //INSTANCIA DA API PIX
        $obApiPix = new Api($url,
                            $client_id,
                            $client_secret,
                            $certificado);
                            
        //print_r($obApiPix);
        
        if($CI->session->userdata('pessoa') == 'F'){
             //CORPO DA REQUISIÇÃO
            $request = [
              'calendario' => [
                'expiracao' => 3600
              ],
              'devedor' => [
                'cpf' => $cpf,
                'nome' => $nome
              ],
              'valor' => [
                'original' => $valor
              ],
              'chave' => $chave,
              'solicitacaoPagador' => $solicitacaoPagador
            ];           
        } else {
             //CORPO DA REQUISIÇÃO
            $request = [
              'calendario' => [
                'expiracao' => 3600
              ],
              'devedor' => [
                'cnpj' => $cpf,
                'nome' => $nome
              ],
              'valor' => [
                'original' => $valor
              ],
              'chave' => $chave,
              'solicitacaoPagador' => $solicitacaoPagador
            ]; 
        }
        
        //print_r($request);
        
        //RESPOSTA DA REQUISIÇÃO DE CRIAÇÃO
        $response = $obApiPix->createCob($request);

       //print_r($response);

        //VERIFICA A EXISTÊNCIA DO ITEM 'LOCATION'
        if(!isset($response['location'])){
          $response['payloadQrCode'] = '';
        } else {
            //INSTANCIA PRINCIPAL DO PAYLOAD PIX
            $obPayload = (new Payload)->setMerchantName($nome)
                                      ->setMerchantCity($cidade)
                                      ->setAmount($response['valor']['original'])
                                      ->setUrl($response['location'])
                                      ->setUniquePayment(true);
                                      
            $response['payloadQrCode'] = $obPayload->getPayload();
        }
        
        return $response;
    }
    
    //Função para criação Pix estático
    function create_pix_estatico($valor, $chave, $solicitacaoPagador, $nome, $cidade, $txid){
        $CI = & get_instance();
        $nome = substr($nome, 0, 25);
        $cidade = substr($cidade, 0, 15);

        //VERIFICA A EXISTÊNCIA DO ITEM 'LOCATION'

        //INSTANCIA PRINCIPAL DO PAYLOAD PIX
        $obPayload = (new Payload)->setPixKey($chave)
                                  ->setMerchantName($nome)
                                  ->setMerchantCity($cidade)
                                  ->setAmount($valor)
                                  ->setTxid($txid);
                                  
        $response['payloadQrCode'] = $obPayload->getPayloadEstatico();
        
        return $response;
    }
    
    //Função para criação do QRCode
    function create_qrcode($codigo){
        //QR CODE
        $obQrCode = new QrCode($codigo);
        
        //IMAGEM DO QRCODE
        $image = (new Output\Png)->output($obQrCode,300);
        
        return $image;
    }

    //Função para consultar Pix
    function consult_pix($url, $client_id, $client_secret, $certificado, $txid){
        $CI = & get_instance();

        $obApiPix = new Api($url,
                            $client_id,
                            $client_secret,
                            $certificado);

        //RESPOSTA DA REQUISIÇÃO DE CRIAÇÃO
        $response = $obApiPix->consultCob($txid);

        //print_r($response);
        
        return $response;
    }

}



